/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.model;

import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import lombok.Data;

import java.util.HashMap;

/**
 * 请求上下文
 *
 * @author liluqing
 * @version RequestContext.java, v 0.1 2023-11-17 16:53
 */
@Data
public class DefaultRequestContext {

    /**
     * 请求唯一标识
     */
    private String requestId;

    /**
     * 客户端配置
     */
    protected DefaultClientConfigModel apiClientConfig;

    /**
     * 本次请求的api
     */
    protected IApiDefinition iApiDefinition;

    /**
     * 客户端信息
     */
    protected ClientInfoModel clientInfoModel;

    /**
     * 扩展参数
     */
    protected HashMap<String, Object> extendParams;

    /**
     * 无须加签，验签的字段
     */
    protected String[] noNeedSignWords;


}