/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.id.service.client;

import com.fshow.id.service.cache.LocalCache;
import com.fshow.id.service.config.RedisIdProduceConfig;
import com.fshow.id.service.expection.IdProduceClientException;
import com.fshow.id.service.pojo.TimeSeqResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public class RedisIdProduceClientBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisIdProduceClientBase.class);
    private static final String DEFAULT_REND_FLAG = "0";
    private static final String SUPPLEMENT_REND_FLAG = "0";
    private static final String EMPTY = "";
    private static final int LOCAL_CACHE_MS_DEVIATION = 1000;
    private LocalCache localCache;
    private String defaultShardingCode;
    private String defaultObligateCode;
    private String defaultBusinessCode;
    private String cacheKeyBase;
    private JedisPool jedisPool;
    private Integer secondExpire;
    private Integer shardingLength;
    private boolean isShardind = true;
    private Integer obligateLength;
    private boolean isObligate = true;
    private Integer businessLength;
    private boolean isBusiness = true;
    private Integer msSequenceLength;
    private Integer msSequenceMax;
    private Integer msSequenceLocalSize;

    RedisIdProduceClientBase(RedisIdProduceConfig config) {
        config.build();
        this.cacheKeyBase = config.getCacheKeyBase();
        this.jedisPool = config.getJedisPool();
        this.secondExpire = config.getSecondExpire();
        this.shardingLength = config.getShardingLength();
        if (this.shardingLength == 0) {
            this.isShardind = false;
        }
        this.obligateLength = config.getObligateLength();
        if (this.obligateLength == 0) {
            this.isObligate = false;
        }
        this.businessLength = config.getBusinessLength();
        if (this.businessLength == 0) {
            this.isBusiness = false;
        }
        this.msSequenceLength = config.getMsSequenceLength();
        this.msSequenceLocalSize = config.getMsSequenceLocalSize();
        int max = 1;
        for (int i = 0; i < this.msSequenceLength; ++i) {
            max *= 10;
        }
        this.msSequenceMax = max;
        this.renderDefaultLocation();
        this.localCache = new LocalCache();
    }

    private void renderDefaultLocation() {
        if (this.isShardind) {
            this.defaultShardingCode = this.getRenderDefault(this.shardingLength);
        }
        if (this.isObligate) {
            this.defaultObligateCode = this.getRenderDefault(this.obligateLength);
        }
        if (this.isBusiness) {
            this.defaultBusinessCode = this.getRenderDefault(this.businessLength);
        }
    }

    private String getRenderDefault(int size) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            builder.append("0");
        }
        return builder.toString();
    }

    String getShardingCode(String currentShardingCode) {
        if (this.isShardind) {
            if (StringUtils.isBlank((CharSequence)currentShardingCode)) {
                return this.defaultShardingCode;
            }
            if (currentShardingCode.length() != this.shardingLength.intValue()) {
                throw IdProduceClientException.SHARDIND_PARAM_LENGTH_ERROR;
            }
            return currentShardingCode;
        }
        return EMPTY;
    }

    String getObligateCode(String currentObligateCode) {
        if (this.isObligate) {
            if (StringUtils.isBlank((CharSequence)currentObligateCode)) {
                return this.defaultObligateCode;
            }
            if (currentObligateCode.length() != this.obligateLength.intValue()) {
                throw IdProduceClientException.OBLIGATE_PARAM_LENGTH_ERROR;
            }
            return currentObligateCode;
        }
        return EMPTY;
    }

    String getBusinessCode(String currentBusinessCode) {
        if (this.isBusiness) {
            if (StringUtils.isBlank((CharSequence)currentBusinessCode)) {
                return this.defaultBusinessCode;
            }
            if (currentBusinessCode.length() != this.businessLength.intValue()) {
                throw IdProduceClientException.BUSINESS_PARAM_LENGTH_ERROR;
            }
            return currentBusinessCode;
        }
        return EMPTY;
    }

    synchronized void getSequenceByCache(TimeSeqResult timeSeqResult) {
        boolean flag = this.tryGetSeqByLocalCache(timeSeqResult);
        if (flag) {
            return;
        }
        this.reGetCacheFromRedis(timeSeqResult);
    }

    private boolean tryGetSeqByLocalCache(TimeSeqResult timeSeqResult) {
        long currentTime = timeSeqResult.getTimeStamp();
        int currentSeq = this.localCache.getCurrentSequence();
        if (currentSeq >= this.localCache.getEndSequence()) {
            return false;
        }
        long dif = currentTime - this.localCache.getCacheTime();
        if (dif >= 0L && dif <= 1000L) {
            this.localCache.setCurrentSequence(currentSeq + 1);
            timeSeqResult.setTimeStamp(this.localCache.getCacheTime());
            timeSeqResult.setSequence(currentSeq);
            return true;
        }
        return false;
    }

    private void reGetCacheFromRedis(TimeSeqResult timeSeqResult) {
        long currentTime = timeSeqResult.getTimeStamp();
        long second = currentTime / 1000L;
        long millsecond = currentTime % 1000L;
        String hash = String.valueOf(millsecond);
        String key = this.cacheKeyBase + second;
        Jedis jedis = this.jedisPool.getResource();
        try {
            long currentRedisEnd = jedis.hincrBy(key, hash, (long)this.msSequenceLocalSize.intValue());
            int startSeq = (int)currentRedisEnd - this.msSequenceLocalSize;
            if (startSeq >= this.msSequenceMax) {
                throw IdProduceClientException.OUT_OF_MAX_SEQUENCE;
            }
            this.localCache.setCacheTime(currentTime);
            this.localCache.setCurrentSequence(startSeq + 1);
            this.localCache.setEndSequence((int)currentRedisEnd);
            timeSeqResult.setSequence(startSeq);
        }
        catch (Exception e) {
            LOGGER.error("id produce com.fshow.id.service.client reGetCacheFromRedis error e={},stack={}", (Object)e.getMessage(), (Object)ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        finally {
            if (jedis != null) {
                jedis.expire(key, this.secondExpire.intValue());
                jedis.close();
            } else {
                Jedis jedisR = this.jedisPool.getResource();
                jedisR.expire(key, this.secondExpire.intValue());
                jedisR.close();
            }
        }
    }

    String supplyRender(int sequence) {
        String sequenceStr = String.valueOf(sequence);
        int length = sequenceStr.length();
        if (length < this.msSequenceLength) {
            int dif = this.msSequenceLength - length;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < dif; ++i) {
                builder.append("0");
            }
            builder.append(sequenceStr);
            return builder.toString();
        }
        return sequenceStr;
    }
}

