/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fsframework.web.service;

import com.fshows.fsframework.core.BaseParam;

/**
 * api客户端
 *
 * @author liluqing
 * @version IApiClient.java, v 0.1 2022-06-28 17:33
 */
public interface IApiClient {

    /**
     * 请求转发,调用实际的业务Api
     *
     * @param method
     * @param paramJsonStr
     * @param invoker
     * @param <P>
     * @param <R>
     * @return
     */
    <P extends BaseParam, R> R invoke(String method, String paramJsonStr, ApiInvoker<P, R> invoker) throws Throwable;

    /**
     * 请求转发,调用实际的业务Api(带traceId)
     *
     * @param method
     * @param paramJsonStr
     * @param invoker
     * @param <P>
     * @param <R>
     * @return
     */
    <P extends BaseParam, R> R invoke2(String method, String paramJsonStr, String traceId, ApiInvoker<P, R> invoker) throws Throwable;

}