/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.domain;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.springframework.util.ReflectionUtils;

public class ApiDescriptor {
    private static final Pattern PATTERN = Pattern.compile("\\s+(.*)\\s+((.*)\\.(.*))\\((.*)\\)", 32);
    private static final int DEFAULT_METHOD_ELEMENT_COUNT = 6;
    private String methodName;
    private String simpleName;
    private String methodFullName;
    private Method method;
    private String classFullName;
    private String returnFullName;
    private String[] paramFullNameList;
    private String beanName;

    public ApiDescriptor(String methodFullame, String apiMethod, String beanName) throws ClassNotFoundException {
        List<String> items = ApiDescriptor.splitMethodName(methodFullame);
        if (items.size() == 6) {
            this.methodName = apiMethod;
            this.returnFullName = items.get(1);
            this.methodFullName = items.get(2);
            this.classFullName = items.get(3);
            this.simpleName = items.get(4);
            String paramItemStr = items.get(5);
            this.paramFullNameList = !StringUtils.isBlank((CharSequence)paramItemStr) ? new String[]{items.get(5)} : new String[0];
            this.beanName = beanName;
            this.method = ReflectionUtils.findMethod(Class.forName(this.classFullName), (String)this.simpleName, (Class[])new Class[]{Class.forName(this.paramFullNameList[0])});
        }
    }

    private static List<String> splitMethodName(String content) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)content)) {
            return result;
        }
        Matcher matcher = PATTERN.matcher(content);
        if (matcher.find()) {
            int groupCount = matcher.groupCount() + 1;
            for (int i = 0; i < groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public String getMethodFullName() {
        return this.methodFullName;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getClassFullName() {
        return this.classFullName;
    }

    public String getReturnFullName() {
        return this.returnFullName;
    }

    public String[] getParamFullNameList() {
        return this.paramFullNameList;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

