/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.web.auth.JwtToken;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtTokenManager {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenManager.class);

    public static JwtToken getToken(String subject, String token) {
        DecodedJWT jwt = JwtTokenManager.parseToken(subject, token);
        JwtToken jwtToken = new JwtToken();
        jwtToken.setIssuedAt(jwt.getIssuedAt());
        jwtToken.setExpiresAt(jwt.getExpiresAt());
        jwtToken.setUserId((String)jwt.getAudience().get(0));
        return jwtToken;
    }

    public static DecodedJWT parseToken(String subject, String token) {
        Algorithm algorithm = Algorithm.HMAC512((String)subject);
        JWTVerifier verifier = JWT.require((Algorithm)algorithm).withIssuer("fshows").build();
        return verifier.verify(token);
    }

    public static String generateToken(String userId, String subject, int minutes) {
        try {
            Date date = new Date();
            DateTime dateTime = new DateTime((Object)date);
            Date expiredTime = dateTime.plusMinutes(minutes).toDate();
            Algorithm algorithm = Algorithm.HMAC512((String)subject);
            return JWT.create().withIssuer("fshows").withIssuedAt(date).withExpiresAt(expiredTime).withJWTId(UUID.randomUUID().toString()).withAudience(new String[]{userId}).sign(algorithm);
        }
        catch (JWTCreationException ex) {
            LogUtil.error((Logger)log, (String)"generateToken>>\u751f\u6210token\u5f02\u5e38\uff1a{}", (Object[])new Object[]{ExceptionUtils.getStackTrace((Throwable)ex)});
            return "";
        }
    }
}

