/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.redis;

import com.fshows.fsframework.core.utils.LogUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.redisson.Redisson;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBucket;
import org.redisson.api.RList;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RSet;
import org.redisson.api.RSortedSet;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    private static final Long DEFAULT_EXPIRED = 300L;
    private static final String REDIS_KEY_PREFIX = "";
    private RedissonClient redisson;
    private String host;
    private String password;
    private Integer connectTimeout;

    @PostConstruct
    public void init() throws IOException {
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.host).setPassword(this.password)).setDatabase(0).setPingTimeout(3000)).setTimeout(5000)).setSubscriptionConnectionMinimumIdleSize(1).setSubscriptionConnectionPoolSize(256).setConnectTimeout(this.connectTimeout.intValue())).setConnectionPoolSize(256).setConnectionMinimumIdleSize(1).setRetryAttempts(3)).setRetryInterval(3000)).setIdleConnectionTimeout(30000)).setClientName("com.fshows.fsframework.extend.redis.RedisCache");
        if (this.redisson == null) {
            this.redisson = Redisson.create((Config)config);
            LogUtil.info((Logger)log, (String)"redis\u8fde\u63a5\u6210\u529f,server={}", (Object[])new Object[]{this.host});
        } else {
            log.warn("redis \u91cd\u590d\u8fde\u63a5,config={}", (Object)config);
        }
    }

    public <T> T get(String key) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        return (T)bucket.get();
    }

    public String getString(String key) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        return (String)bucket.get();
    }

    public <T> void put(String key, T value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        bucket.set(value, DEFAULT_EXPIRED.longValue(), TimeUnit.SECONDS);
    }

    public <T> void put(String key, T value, Codec codec) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, codec);
        bucket.set(value, DEFAULT_EXPIRED.longValue(), TimeUnit.SECONDS);
    }

    public <T> void put(String key, T value, long expired, Codec codec) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, codec);
        bucket.set(value, expired, TimeUnit.SECONDS);
    }

    public <T> T get(String key, Codec codec) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, codec);
        return (T)bucket.get();
    }

    public void putString(String key, String value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        bucket.set((Object)value, DEFAULT_EXPIRED.longValue(), TimeUnit.SECONDS);
    }

    public void putStringWithoutExpire(String key, String value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        bucket.set((Object)value);
    }

    public void putString(String key, String value, long expired) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        bucket.set((Object)value, expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
    }

    public boolean putStringIfAbsent(String key, String value, long expired) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        return bucket.trySet((Object)value, expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
    }

    public boolean putStringIfAbsent(String key, String value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        return bucket.trySet((Object)value);
    }

    public void putMap(String key, String mapKey, String mapValue) {
        RMap concurrentMap = this.redisson.getMap(key);
        concurrentMap.put(mapKey, mapValue);
    }

    public ConcurrentMap<String, String> getHashMap(String key) {
        return this.redisson.getMap(key);
    }

    public ConcurrentMap<String, String> getHashMapString(String redisKey) {
        return this.redisson.getMap(redisKey, (Codec)StringCodec.INSTANCE);
    }

    public void removeHashMapValue(String key, String mapKey) {
        RMap concurrentMap = this.redisson.getMap(key);
        concurrentMap.remove(mapKey);
    }

    public <T> void put(String key, T value, long expired) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        bucket.set(value, expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
    }

    public long getAndIncrement(String key, long expired) {
        RAtomicLong atomicLong = this.redisson.getAtomicLong(key);
        long num = atomicLong.getAndIncrement();
        atomicLong.expire(expired, TimeUnit.SECONDS);
        return num;
    }

    public long getAndIncrement(String key, long delta, long expired) {
        RAtomicLong atomicLong = this.redisson.getAtomicLong(key);
        long num = atomicLong.getAndAdd(delta);
        atomicLong.expire(expired, TimeUnit.SECONDS);
        return num;
    }

    public void remove(String key) {
        this.redisson.getBucket(REDIS_KEY_PREFIX + key).delete();
    }

    public boolean exists(String key) {
        return this.redisson.getBucket(REDIS_KEY_PREFIX + key).isExists();
    }

    public <T> RList<T> getRedisList(String key) {
        return this.redisson.getList(REDIS_KEY_PREFIX + key);
    }

    public <T> RList<T> getRedisListString(String key) {
        return this.redisson.getList(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
    }

    public <K, V> RMapCache<K, V> getRedisMap(String key) {
        return this.redisson.getMapCache(REDIS_KEY_PREFIX + key);
    }

    public <K, V> RMapCache<K, V> getRedisMapString(String key) {
        return this.redisson.getMapCache(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
    }

    public <T> RSet<T> getRedisSet(String key) {
        return this.redisson.getSet(REDIS_KEY_PREFIX + key);
    }

    public <T> RSet<T> getRedisSetString(String key) {
        return this.redisson.getSet(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
    }

    public RLock getRedisLock(String key) {
        return this.redisson.getLock(REDIS_KEY_PREFIX + key);
    }

    public <T> RSortedSet<T> getSortedSet(String key) {
        return this.redisson.getSortedSet(REDIS_KEY_PREFIX + key);
    }

    public <T> RSortedSet<T> getSortedSet(String key, Codec codec) {
        return this.redisson.getSortedSet(REDIS_KEY_PREFIX + key, codec);
    }

    public <T> RScoredSortedSet<T> getScoredSortedSet(String key) {
        return this.redisson.getScoredSortedSet(REDIS_KEY_PREFIX + key);
    }

    public <T> RScoredSortedSet<T> getScoredSortedSet(String key, Codec codec) {
        return this.redisson.getScoredSortedSet(REDIS_KEY_PREFIX + key, codec);
    }

    public void putSetBatch(String key, Set set, long expired) {
        RBatch batch = this.redisson.createBatch();
        batch.getSet(REDIS_KEY_PREFIX + key).addAllAsync((Collection)set);
        batch.execute();
        this.redisson.getSet(REDIS_KEY_PREFIX + key).expire(expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
    }

    public RSet<Object> diffAsync(String sourceKey, String compareKey, String resultKey, long expired) {
        this.redisson.getSet(REDIS_KEY_PREFIX + resultKey).diffAsync(new String[]{REDIS_KEY_PREFIX + sourceKey, REDIS_KEY_PREFIX + compareKey});
        this.redisson.getSet(REDIS_KEY_PREFIX + resultKey).expire(expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
        return this.redisson.getSet(REDIS_KEY_PREFIX + resultKey);
    }

    @PreDestroy
    public void close() {
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception ex) {
            LogUtil.error((Logger)log, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

