/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.cluster;

import com.alibaba.dubbo.rpc.support.RpcUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.NetUtils;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.cluster.Directory;
import org.apache.dubbo.rpc.cluster.LoadBalance;
import org.apache.dubbo.rpc.cluster.support.AbstractClusterInvoker;

public class DockerClusterInvoker<T>
implements Invoker<T> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractClusterInvoker.class);
    public final Directory<T> directory;
    public final boolean availablecheck;
    private AtomicBoolean destroyed = new AtomicBoolean(false);
    private volatile Invoker<T> stickyInvoker = null;

    public DockerClusterInvoker(Directory<T> directory) {
        this(directory, directory.getUrl());
    }

    public DockerClusterInvoker(Directory<T> directory, URL url) {
        if (directory == null) {
            throw new IllegalArgumentException("service directory == null");
        }
        this.directory = directory;
        this.availablecheck = url.getParameter("cluster.availablecheck", true);
    }

    public Class<T> getInterface() {
        return this.directory.getInterface();
    }

    public URL getUrl() {
        return this.directory.getUrl();
    }

    public boolean isAvailable() {
        Invoker<T> invoker = this.stickyInvoker;
        if (invoker != null) {
            return invoker.isAvailable();
        }
        return this.directory.isAvailable();
    }

    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.directory.destroy();
        }
    }

    protected Invoker<T> select(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected) throws RpcException {
        if (invokers == null || invokers.isEmpty()) {
            return null;
        }
        String methodName = invocation == null ? "" : invocation.getMethodName();
        boolean sticky = invokers.get(0).getUrl().getMethodParameter(methodName, "sticky", false);
        if (this.stickyInvoker != null && !invokers.contains(this.stickyInvoker)) {
            this.stickyInvoker = null;
        }
        if (sticky && this.stickyInvoker != null && (selected == null || !selected.contains(this.stickyInvoker)) && this.availablecheck && this.stickyInvoker.isAvailable()) {
            return this.stickyInvoker;
        }
        Invoker<T> invoker = this.doSelect(loadbalance, invocation, invokers, selected);
        if (sticky) {
            this.stickyInvoker = invoker;
        }
        return invoker;
    }

    private Invoker<T> doSelect(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected) throws RpcException {
        if (invokers == null || invokers.isEmpty()) {
            return null;
        }
        if (loadbalance == null) {
            loadbalance = (LoadBalance)ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension("random");
        }
        Invoker<T> invoker = loadbalance.select(invokers, this.getUrl(), invocation);
        if (selected != null && selected.contains(invoker) || !invoker.isAvailable() && this.getUrl() != null && this.availablecheck) {
            try {
                Invoker<T> rinvoker = this.reselect(loadbalance, invocation, invokers, selected, this.availablecheck);
                if (rinvoker != null) {
                    invoker = rinvoker;
                } else {
                    int index = invokers.indexOf(invoker);
                    try {
                        invoker = index < invokers.size() - 1 ? invokers.get(index + 1) : invoker;
                    }
                    catch (Exception e) {
                        logger.warn(e.getMessage() + " may because invokers list dynamic change, ignore.", (Throwable)e);
                    }
                }
            }
            catch (Throwable t) {
                logger.error("cluster reselect fail reason is :" + t.getMessage() + " if can not solve, you can set cluster.availablecheck=false in url", t);
            }
        }
        return invoker;
    }

    private Invoker<T> reselect(LoadBalance loadbalance, Invocation invocation, List<Invoker<T>> invokers, List<Invoker<T>> selected, boolean availablecheck) throws RpcException {
        ArrayList<Invoker<T>> reselectInvokers = new ArrayList<Invoker<T>>(invokers.size() > 1 ? invokers.size() - 1 : invokers.size());
        if (availablecheck) {
            for (Invoker<T> invoker : invokers) {
                if (!invoker.isAvailable() || selected != null && selected.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
            if (!reselectInvokers.isEmpty()) {
                return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
            }
        } else {
            for (Invoker<T> invoker : invokers) {
                if (selected != null && selected.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
            if (!reselectInvokers.isEmpty()) {
                return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
            }
        }
        if (selected != null) {
            for (Invoker<T> invoker : selected) {
                if (!invoker.isAvailable() || reselectInvokers.contains(invoker)) continue;
                reselectInvokers.add(invoker);
            }
        }
        if (!reselectInvokers.isEmpty()) {
            return loadbalance.select(reselectInvokers, this.getUrl(), invocation);
        }
        return null;
    }

    public Result invoke(Invocation invocation) throws RpcException {
        this.checkWhetherDestroyed();
        LoadBalance loadbalance = null;
        List<Invoker<T>> invokers = this.list(invocation);
        if (invokers != null && !invokers.isEmpty()) {
            loadbalance = (LoadBalance)ExtensionLoader.getExtensionLoader(LoadBalance.class).getExtension(invokers.get(0).getUrl().getMethodParameter(invocation.getMethodName(), "loadbalance", "random"));
        }
        RpcUtils.attachInvocationIdIfAsync((URL)this.getUrl(), (Invocation)invocation);
        return this.doInvoke(invocation, invokers, loadbalance);
    }

    protected void checkWhetherDestroyed() {
        if (this.destroyed.get()) {
            throw new RpcException("Rpc cluster invoker for " + this.getInterface() + " on consumer " + NetUtils.getLocalHost() + " use dubbo version " + Version.getVersion() + " is now destroyed! Can not invoke any more.");
        }
    }

    public String toString() {
        return this.getInterface() + " -> " + this.getUrl().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result doInvoke(Invocation invocation, List<Invoker<T>> invokers, LoadBalance loadbalance) throws RpcException {
        List<Invoker<T>> copyinvokers = invokers;
        int len = this.getUrl().getMethodParameter(invocation.getMethodName(), "retries", 2) + 1;
        if (len <= 0) {
            len = 1;
        }
        RpcException le = null;
        ArrayList<Invoker<T>> invoked = new ArrayList<Invoker<T>>(copyinvokers.size());
        HashSet<String> providers = new HashSet<String>(len);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                this.checkWhetherDestroyed();
                copyinvokers = this.list(invocation);
            }
            Invoker<T> invoker = this.select(loadbalance, invocation, copyinvokers, invoked);
            invoked.add(invoker);
            RpcContext.getContext().setInvokers(invoked);
            try {
                Result result;
                Result result2 = result = invoker.invoke(invocation);
                return result2;
            }
            catch (RpcException e) {
                if (e.isBiz()) {
                    throw e;
                }
                le = e;
                continue;
            }
            catch (Throwable e) {
                le = new RpcException(e.getMessage(), e);
                continue;
            }
            finally {
                providers.add(invoker.getUrl().getAddress());
            }
        }
        if (copyinvokers.isEmpty()) {
            throw new RpcException("No provider available in " + invokers);
        }
        throw le;
    }

    protected List<Invoker<T>> list(Invocation invocation) throws RpcException {
        try {
            List invokers = this.directory.list(invocation);
            return invokers;
        }
        catch (Exception ex) {
            ArrayList<Invoker<T>> stableInvokers = new ArrayList<Invoker<T>>();
            return stableInvokers;
        }
    }
}

