/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.mq.util;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class MqInstanceUtil {
    public static String generateProducerInstanceKey(Properties properties, Object instance) {
        StringBuilder keyBuilder = new StringBuilder("producer");
        String producerId = properties.getProperty("ProducerId");
        if (StringUtils.isBlank((CharSequence)producerId)) {
            producerId = properties.getProperty("GROUP_ID");
        }
        if (StringUtils.isNotBlank((CharSequence)producerId)) {
            keyBuilder.append("_").append(producerId);
        }
        keyBuilder.append("_").append(System.identityHashCode(instance));
        keyBuilder.append("_").append(System.currentTimeMillis());
        return keyBuilder.toString();
    }

    public static String generateConsumerInstanceKey(Properties properties, Object instance) {
        StringBuilder keyBuilder = new StringBuilder("consumer");
        String consumerId = properties.getProperty("ConsumerId");
        if (StringUtils.isBlank((CharSequence)consumerId)) {
            consumerId = properties.getProperty("GROUP_ID");
        }
        if (StringUtils.isNotBlank((CharSequence)consumerId)) {
            keyBuilder.append("_").append(consumerId);
        }
        keyBuilder.append("_").append(System.identityHashCode(instance));
        keyBuilder.append("_").append(System.currentTimeMillis());
        return keyBuilder.toString();
    }

    public static boolean isValidMqProperties(Properties properties) {
        if (properties == null) {
            return false;
        }
        String accessKey = properties.getProperty("AccessKey");
        String secretKey = properties.getProperty("SecretKey");
        String nameServer = properties.getProperty("NAMESRV_ADDR");
        return StringUtils.isNotBlank((CharSequence)accessKey) && StringUtils.isNotBlank((CharSequence)secretKey) && StringUtils.isNotBlank((CharSequence)nameServer);
    }

    public static Properties copyProperties(Properties source) {
        if (source == null) {
            return new Properties();
        }
        Properties target = new Properties();
        target.putAll((Map<?, ?>)source);
        return target;
    }

    public static Properties mergeProperties(Properties source, Properties target) {
        Properties merged = MqInstanceUtil.copyProperties(source);
        if (target != null) {
            merged.putAll((Map<?, ?>)target);
        }
        return merged;
    }

    public static String getInstanceType(String instanceKey) {
        if (StringUtils.isBlank((CharSequence)instanceKey)) {
            return "unknown";
        }
        if (instanceKey.startsWith("producer")) {
            return "Producer";
        }
        if (instanceKey.startsWith("consumer")) {
            return "Consumer";
        }
        return "unknown";
    }

    public static String extractIdFromInstanceKey(String instanceKey) {
        if (StringUtils.isBlank((CharSequence)instanceKey)) {
            return "";
        }
        String[] parts = instanceKey.split("_");
        if (parts.length >= 2) {
            return parts[1];
        }
        return "";
    }
}

