/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import com.fshows.fsframework.common.exception.BaseException;
import java.lang.reflect.Method;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;

@Activate(group={"provider"})
public class GlobalExceptionFilter
extends ListenableFilter {
    public GlobalExceptionFilter() {
        this.listener = new ExceptionListener();
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    static class ExceptionListener
    implements Filter.Listener {
        private Logger logger = LoggerFactory.getLogger(ExceptionListener.class);

        ExceptionListener() {
        }

        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            if (appResponse.hasException() && GenericService.class != invoker.getInterface()) {
                try {
                    Throwable exception = appResponse.getException();
                    if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                        return;
                    }
                    try {
                        Class<?>[] exceptionClassses;
                        Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                        for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                            if (!exception.getClass().equals(exceptionClass)) continue;
                            return;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        return;
                    }
                    this.logger.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
                    String serviceFile = ReflectUtils.getCodeBase((Class)invoker.getInterface());
                    String exceptionFile = ReflectUtils.getCodeBase(exception.getClass());
                    if (serviceFile == null || exceptionFile == null || serviceFile.equals(exceptionFile) || exception instanceof BaseException) {
                        return;
                    }
                    String className = exception.getClass().getName();
                    if (className.startsWith("java.") || className.startsWith("javax.")) {
                        return;
                    }
                    if (exception instanceof RpcException) {
                        return;
                    }
                    appResponse.setException((Throwable)new RuntimeException(StringUtils.toString((Throwable)exception)));
                    return;
                }
                catch (Throwable e) {
                    this.logger.warn("Fail to ExceptionFilter when called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
                    return;
                }
            }
        }

        public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
            this.logger.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }

        public void setLogger(Logger logger) {
            this.logger = logger;
        }
    }
}

