/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.idgen.worker.repos;


import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.idgen.cache.WorkerIdFileCache;
import com.fshows.fsframework.extend.idgen.exception.WorkerIdAssignException;
import com.fshows.fsframework.extend.idgen.worker.WorkerNode;
import lombok.extern.slf4j.Slf4j;

import java.util.Date;

/**
 * @author wujn
 * @version $Id BaseWorkerNodeRepository.java, v 0.1 2018-02-01 14:46
 */
@Slf4j
public abstract class BaseWorkerNodeRepository implements WorkerNodeRepository {
    /**
     * defualt worker id
     */
    private static final Long DEFAULT_WORKER_ID = 1L;

    @Override
    public final synchronized  long assignWorkerId(String ipAddress, String appName)  {
        try {
            WorkerNode workerNode = get(ipAddress, appName);
            if (workerNode == null) {
                //insert a new worker node
                workerNode = new WorkerNode();
                workerNode.setAppName(appName);
                workerNode.setCreated(new Date());
                workerNode.setModified(new Date());
                workerNode.setHostName(ipAddress);
                workerNode.setWorkerId(DEFAULT_WORKER_ID);
                insert(workerNode);
            }
            WorkerIdFileCache.writeCache(appName, workerNode);
            return workerNode.getWorkerId();
        } catch (Exception ex) {
            LogUtil.error(log, "assign worker id error ", ex);
            WorkerNode cachedWorkNode = (WorkerNode) WorkerIdFileCache.getDataFromFile(appName);
            if (cachedWorkNode != null) {
                return cachedWorkNode.getWorkerId();
            }
            throw new WorkerIdAssignException(ex.getMessage(), ex);
        }
    }


    /**
     * insert a worker node
     *
     * @param workerNode
     */
    public abstract void insert(WorkerNode workerNode) ;

    /**
     * get a worker node
     *
     * @param hostName
     * @param appName
     * @return
     */
    public abstract WorkerNode get(String hostName, String appName);
}
