/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.fsframework.extend.idgen.impl;

import lombok.Data;

/**
 * 雪花ID生成器()
 *
 * @author liluqing
 * @version FsSnowflakeIdConfig.java, v 0.1 2022-11-10 17:47
 */
@Data
public class FsSnowflakeIdConfig {

    /**
     * 日期后的数字位数
     */
    private int numberLength = 6;

    /**
     * workerId占用的bit位数
     */
    private int workerIdBits = 4;

    /**
     * 序列号占用的bit位数
     */
    private int sequenceBits = 16;

    /**
     * seq溢出处理策略：
     *      0 - 抛出异常
     *      1 - 重置序列号然后继续生成唯一ID（可能会生成重复的ID）
     */
    private int  seqOverflowStrategy = 1;

    /**
     * 时间回退处理策略：
     *      0 - 抛出异常
     *      1 - 按照当前时间继续生成ID（可能会生成重复的序列号）
     */
    private int  timeFallbackStrategy = 1;
}