/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.extension.factory;

import com.fshows.fsframework.extend.extension.BusinessScenario;
import com.fshows.fsframework.extend.extension.IExtensionPoint;

/**
 * @author liangyuanping
 * @version ExtensionFactory.java, v 0.1 2022-07-16 7:39 下午 liangyuanping
 */
public interface ExtensionFactory {
    /**
     * 扩展点注册
     *
     * @param extensionObject 扩展点
     */
    void doRegister(IExtensionPoint extensionObject);

    /**
     * 获取扩展点
     *
     * @param businessScenario
     * @param clazz
     * @param <T>
     * @return
     */
    <T> T get(BusinessScenario businessScenario, Class<T> clazz);
}