/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.mq.core;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.aliyun.mq.config.FsMqConfig;
import com.fshows.fsframework.extend.aliyun.mq.decorator.FsConsumerBean;
import com.fshows.fsframework.extend.aliyun.mq.decorator.FsProducerBean;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsMqInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(FsMqInstanceManager.class);
    private final ConcurrentHashMap<String, ProducerInstanceInfo> producerRegistry = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConsumerInstanceInfo> consumerRegistry = new ConcurrentHashMap();
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(4);
    private final Random random = new Random();
    private FsMqConfig fsMqConfig;

    public void registerProducer(String instanceKey, FsProducerBean producerBean, Properties properties) {
        ProducerInstanceInfo info = new ProducerInstanceInfo(producerBean, properties);
        this.producerRegistry.put(instanceKey, info);
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u6ce8\u518cProducer\u5b9e\u4f8b: {}", (Object[])new Object[]{instanceKey});
    }

    public void registerConsumer(String instanceKey, FsConsumerBean consumerBean, Properties properties, Map<Subscription, MessageListener> subscriptionTable) {
        ConsumerInstanceInfo info = new ConsumerInstanceInfo(consumerBean, properties, subscriptionTable);
        this.consumerRegistry.put(instanceKey, info);
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u6ce8\u518cConsumer\u5b9e\u4f8b: {}", (Object[])new Object[]{instanceKey});
    }

    public void unregisterProducer(String instanceKey) {
        this.producerRegistry.remove(instanceKey);
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u6ce8\u9500Producer\u5b9e\u4f8b: {}", (Object[])new Object[]{instanceKey});
    }

    public void unregisterConsumer(String instanceKey) {
        this.consumerRegistry.remove(instanceKey);
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u6ce8\u9500Consumer\u5b9e\u4f8b: {}", (Object[])new Object[]{instanceKey});
    }

    public void updateAllProducers() {
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u5f00\u59cb\u66f4\u65b0\u6240\u6709Producer\u5b9e\u4f8b\uff0c\u5171{}\u4e2a", (Object[])new Object[]{this.producerRegistry.size()});
        for (Map.Entry<String, ProducerInstanceInfo> entry : this.producerRegistry.entrySet()) {
            String instanceKey = entry.getKey();
            ProducerInstanceInfo info = entry.getValue();
            try {
                this.updateProducerInstance(instanceKey, info);
            }
            catch (Exception e) {
                LogUtil.error((Logger)log, (String)"FsMqInstanceManager >> \u66f4\u65b0Producer\u5b9e\u4f8b\u5931\u8d25: {}", (Throwable)e, (Object[])new Object[]{instanceKey});
            }
        }
    }

    public void updateAllConsumers() {
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u5f00\u59cb\u66f4\u65b0\u6240\u6709Consumer\u5b9e\u4f8b\uff0c\u5171{}\u4e2a", (Object[])new Object[]{this.consumerRegistry.size()});
        for (Map.Entry<String, ConsumerInstanceInfo> entry : this.consumerRegistry.entrySet()) {
            String instanceKey = entry.getKey();
            ConsumerInstanceInfo info = entry.getValue();
            try {
                this.updateConsumerInstance(instanceKey, info);
            }
            catch (Exception e) {
                LogUtil.error((Logger)log, (String)"FsMqInstanceManager >> \u66f4\u65b0Consumer\u5b9e\u4f8b\u5931\u8d25: {}", (Throwable)e, (Object[])new Object[]{instanceKey});
            }
        }
    }

    private void updateProducerInstance(String instanceKey, ProducerInstanceInfo info) {
        FsProducerBean producerBean = info.getProducerBean();
        Properties newProperties = this.updateProperties(info.getOriginalProperties());
        Producer newProducerImpl = ONSFactory.createProducer((Properties)newProperties);
        newProducerImpl.start();
        Producer oldProducerImpl = producerBean.replaceProducerInstance(newProducerImpl);
        if (oldProducerImpl != null) {
            int delayTime = this.fsMqConfig.getProducerCloseDelayTime();
            this.executorService.schedule(() -> {
                try {
                    oldProducerImpl.shutdown();
                    LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u5ef6\u8fdf\u5173\u95ed\u65e7Producer\u5b9e\u4f8b: {}", (Object[])new Object[]{instanceKey});
                }
                catch (Exception e) {
                    LogUtil.error((Logger)log, (String)"FsMqInstanceManager >> \u5173\u95ed\u65e7Producer\u5b9e\u4f8b\u5931\u8d25: {}", (Throwable)e, (Object[])new Object[]{instanceKey});
                }
            }, (long)delayTime, TimeUnit.SECONDS);
        }
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> Producer\u5b9e\u4f8b\u66f4\u65b0\u5b8c\u6210: {}", (Object[])new Object[]{instanceKey});
    }

    private void updateConsumerInstance(String instanceKey, ConsumerInstanceInfo info) {
        int maxDelay = this.fsMqConfig.getConsumerRestartDelayTime();
        int randomDelay = 1 + this.random.nextInt(Math.max(1, maxDelay));
        this.executorService.schedule(() -> {
            try {
                FsConsumerBean consumerBean = info.getConsumerBean();
                consumerBean.shutdown();
                Properties newProperties = this.updateProperties(info.getOriginalProperties());
                Consumer newConsumerImpl = ONSFactory.createConsumer((Properties)newProperties);
                consumerBean.replaceConsumerInstance(newConsumerImpl, info.getSubscriptionTable());
                consumerBean.start();
                LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> Consumer\u5b9e\u4f8b\u91cd\u542f\u5b8c\u6210: {}", (Object[])new Object[]{instanceKey});
            }
            catch (Exception e) {
                LogUtil.error((Logger)log, (String)"FsMqInstanceManager >> Consumer\u5b9e\u4f8b\u91cd\u542f\u5931\u8d25: {}", (Throwable)e, (Object[])new Object[]{instanceKey});
            }
        }, (long)randomDelay, TimeUnit.SECONDS);
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> Consumer\u5b9e\u4f8b\u5df2\u5b89\u6392{}\u79d2\u540e\u91cd\u542f: {}", (Object[])new Object[]{randomDelay, instanceKey});
    }

    private Properties updateProperties(Properties originalProperties) {
        Properties newProperties = new Properties();
        newProperties.putAll((Map<?, ?>)originalProperties);
        newProperties.setProperty("AccessKey", this.fsMqConfig.getDecryptedAccessKey());
        newProperties.setProperty("SecretKey", this.fsMqConfig.getDecryptedSecretKey());
        return newProperties;
    }

    public int getProducerCount() {
        return this.producerRegistry.size();
    }

    public int getConsumerCount() {
        return this.consumerRegistry.size();
    }

    public void shutdown() {
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> \u5173\u95edMQ\u5b9e\u4f8b\u7ba1\u7406\u5668");
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public void setFsMqConfig(FsMqConfig fsMqConfig) {
        this.fsMqConfig = fsMqConfig;
    }

    private static class ConsumerInstanceInfo {
        private final FsConsumerBean consumerBean;
        private final Properties originalProperties;
        private final Map<Subscription, MessageListener> subscriptionTable;

        public ConsumerInstanceInfo(FsConsumerBean consumerBean, Properties originalProperties, Map<Subscription, MessageListener> subscriptionTable) {
            this.consumerBean = consumerBean;
            this.originalProperties = new Properties();
            this.originalProperties.putAll((Map<?, ?>)originalProperties);
            this.subscriptionTable = subscriptionTable;
        }

        public FsConsumerBean getConsumerBean() {
            return this.consumerBean;
        }

        public Properties getOriginalProperties() {
            return this.originalProperties;
        }

        public Map<Subscription, MessageListener> getSubscriptionTable() {
            return this.subscriptionTable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConsumerInstanceInfo)) {
                return false;
            }
            ConsumerInstanceInfo other = (ConsumerInstanceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FsConsumerBean this$consumerBean = this.getConsumerBean();
            FsConsumerBean other$consumerBean = other.getConsumerBean();
            if (this$consumerBean == null ? other$consumerBean != null : !this$consumerBean.equals(other$consumerBean)) {
                return false;
            }
            Properties this$originalProperties = this.getOriginalProperties();
            Properties other$originalProperties = other.getOriginalProperties();
            if (this$originalProperties == null ? other$originalProperties != null : !((Object)this$originalProperties).equals(other$originalProperties)) {
                return false;
            }
            Map<Subscription, MessageListener> this$subscriptionTable = this.getSubscriptionTable();
            Map<Subscription, MessageListener> other$subscriptionTable = other.getSubscriptionTable();
            return !(this$subscriptionTable == null ? other$subscriptionTable != null : !((Object)this$subscriptionTable).equals(other$subscriptionTable));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConsumerInstanceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FsConsumerBean $consumerBean = this.getConsumerBean();
            result = result * 59 + ($consumerBean == null ? 43 : $consumerBean.hashCode());
            Properties $originalProperties = this.getOriginalProperties();
            result = result * 59 + ($originalProperties == null ? 43 : ((Object)$originalProperties).hashCode());
            Map<Subscription, MessageListener> $subscriptionTable = this.getSubscriptionTable();
            result = result * 59 + ($subscriptionTable == null ? 43 : ((Object)$subscriptionTable).hashCode());
            return result;
        }

        public String toString() {
            return "FsMqInstanceManager.ConsumerInstanceInfo(consumerBean=" + this.getConsumerBean() + ", originalProperties=" + this.getOriginalProperties() + ", subscriptionTable=" + this.getSubscriptionTable() + ")";
        }
    }

    private static class ProducerInstanceInfo {
        private final FsProducerBean producerBean;
        private final Properties originalProperties;

        public ProducerInstanceInfo(FsProducerBean producerBean, Properties originalProperties) {
            this.producerBean = producerBean;
            this.originalProperties = new Properties();
            this.originalProperties.putAll((Map<?, ?>)originalProperties);
        }

        public FsProducerBean getProducerBean() {
            return this.producerBean;
        }

        public Properties getOriginalProperties() {
            return this.originalProperties;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProducerInstanceInfo)) {
                return false;
            }
            ProducerInstanceInfo other = (ProducerInstanceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FsProducerBean this$producerBean = this.getProducerBean();
            FsProducerBean other$producerBean = other.getProducerBean();
            if (this$producerBean == null ? other$producerBean != null : !this$producerBean.equals(other$producerBean)) {
                return false;
            }
            Properties this$originalProperties = this.getOriginalProperties();
            Properties other$originalProperties = other.getOriginalProperties();
            return !(this$originalProperties == null ? other$originalProperties != null : !((Object)this$originalProperties).equals(other$originalProperties));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ProducerInstanceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FsProducerBean $producerBean = this.getProducerBean();
            result = result * 59 + ($producerBean == null ? 43 : $producerBean.hashCode());
            Properties $originalProperties = this.getOriginalProperties();
            result = result * 59 + ($originalProperties == null ? 43 : ((Object)$originalProperties).hashCode());
            return result;
        }

        public String toString() {
            return "FsMqInstanceManager.ProducerInstanceInfo(producerBean=" + this.getProducerBean() + ", originalProperties=" + this.getOriginalProperties() + ")";
        }
    }
}

