/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package
        com.fshows.fsframework.extend.transaction;

import java.util.function.Supplier;

/**
 * 事务管理器接口
 *
 * @author Liluqing
 * @version TransactionManager.java, v 0.1 2018-10-22 14:04
 */
public interface FsTransactionManager {

    /**
     * 事务模版（带自定义回滚业务逻辑）
     *
     * @returnClass 返回值的类型
     * @param serviceHandle 业务操作
     * @param serviceRollback 业务回滚操作，如果返回true，则回滚。如果返回false，则提交事务
     * @return
     */
    <T> T execute(Supplier<T> serviceHandle, ServiceRollback serviceRollback);

    /**
     * 事务模版（带自定义回滚业务逻辑）
     *      不返回任何结果
     * @param serviceHandle 业务操作
     * @param serviceRollback 业务回滚操作，如果返回true，则回滚。如果返回false，则提交事务
     */
    void executeNoReturn(ServiceHandle serviceHandle, ServiceRollback serviceRollback);
}