/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.idgen.worker;

import com.alibaba.dubbo.common.utils.NetUtils;
import com.fshows.fsframework.extend.idgen.exception.WorkerIdAssignException;
import com.fshows.fsframework.extend.idgen.worker.repos.WorkerNodeRepository;
import org.apache.commons.lang3.StringUtils;

import java.net.InetAddress;

/**
 * @author wujn
 * @version $Id ReuseableWorkerIdAssigner.java, v 0.1 2018-01-24 10:30
 */
public class ReuseableWorkerIdAssigner implements WorkerIdAssigner {

    private WorkerNodeRepository workerNodeRepository;
    /**
     * if a worker node only deployed one application, the application name can be empty.
     * otherwise a worker node deployed multi-application,the app name is necessary.
     */
    private String appName;

    @Override
    public long assignWorkerId() {
        InetAddress ipAddress = NetUtils.getLocalAddress();
        if (ipAddress == null || StringUtils.isBlank(ipAddress.getHostAddress())) {
            throw new WorkerIdAssignException("ipaddress is not valid " + ipAddress);
        }
        return workerNodeRepository.assignWorkerId(ipAddress.getHostAddress(), appName);
    }

    /**
     * Setter method for property <tt>appName</tt>.
     *
     * @param appName value to be assigned to property appName
     */
    public void setAppName(String appName) {
        if (StringUtils.isBlank(appName)) {
            this.appName = "default-app";
        } else {
            this.appName = appName;
        }
    }

    /**
     * Setter method for property <tt>workerNodeRepository</tt>.
     *
     * @param workerNodeRepository value to be assigned to property workerNodeRepository
     */
    public void setWorkerNodeRepository(WorkerNodeRepository workerNodeRepository) {
        this.workerNodeRepository = workerNodeRepository;
    }
}
