package com.fshows.fsframework.extend.dubbo.model;

import lombok.Data;
import java.util.List;

/**
 * dubbo方法监控配置model
 *
 * @author zhaoxumin
 * @version DubboMethodMonitorConfigModel.java, v 0.1 2023-06-01 22:27 zhaoxumin
 */
@Data
public class DubboMethodMonitorConfigModel {

    /**
     * 监控点配置列表
     */
    private List<MethodMonitorPointConfigModel> methodMonitorPointConfigList;

    @Data
    public static class MethodMonitorPointConfigModel {

        /**
         * 方法名称. 支持配置多个，以,分隔
         */
        private String methodName;

        /**
         * 监控点配置列表
         */
        private List<MethodMonitorLevelConfigModel> methodMonitorLevelConfigList;
    }

    @Data
    public static class MethodMonitorLevelConfigModel {

        /**
         * 耗时等级
         */
        private String level;

        /**
         * 下限阈值
         */
        private Integer lowerThreshold;
    }
}
