/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fsframework.extend.dubbo.cluster;

import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.cluster.Cluster;
import com.alibaba.dubbo.rpc.cluster.Directory;

/**
 * @author wujn
 * @version DockerCluster.java, v 0.1 2020-04-20 3:48 PM wujn
 */
public class DockerCluster implements Cluster {

    public final static String NAME = "docker";

    @Override
    public <T> Invoker<T> join(Directory<T> directory) throws RpcException {
        return new DockerClusterInvoker<>(directory);
    }
}
