/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.config;

import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.extension.ExtensionBootstrap;
import com.fshows.fsframework.extend.extension.ExtensionRepository;
import com.fshows.fsframework.extend.extension.context.ExtensionContextHolder;
import com.fshows.fsframework.extend.extension.context.ExtensionExecutor;
import com.fshows.fsframework.extend.extension.factory.ExtensionRegisterFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

/**
 * 使扩展点组件自动装配类
 *
 * @author liangyuanping
 * @version BusinessExtensionAutoConfiguration.java, v 0.1 2022-07-16 12:03 上午 liangyuanping
 */
@Configuration
@Slf4j
public class BusinessExtensionAutoConfiguration {

    @Bean
    @ConditionalOnMissingBean(ExtensionBootstrap.class)
    public ExtensionBootstrap extensionBootstrap() {
        LogUtil.info(log,">>>>>>init extensionBootstrap");
        return new ExtensionBootstrap();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionContextHolder.class)
    public ExtensionContextHolder extensionContextHolder() {
        return new ExtensionContextHolder();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionRegisterFactory.class)
    public ExtensionRegisterFactory extensionRegisterFactory() {
        return new ExtensionRegisterFactory();
    }

    @Bean
    @ConditionalOnMissingBean(ExtensionRepository.class)
    public ExtensionRepository extensionRepository() {
        return new ExtensionRepository();
    }

    @Bean
    @DependsOn("extensionBootstrap")
    @ConditionalOnMissingBean(ExtensionExecutor.class)
    public ExtensionExecutor extensionExecutor() {
        LogUtil.info(log,">>>>>>init extensionExecutor");
        return new ExtensionExecutor();
    }
}