/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.idgen.cache;

import com.fshows.fsframework.core.codec.JavaSerializer;
import com.fshows.fsframework.core.utils.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;

import java.io.File;

/**
 * worker id
 *
 * @author wujn
 * @version $Id WorkerIdFileCache.java, v 0.1 2018-01-29 11:21
 */
@Slf4j
public class WorkerIdFileCache {
    /**
     * get default file cache path
     * eg:
     * linux:/home/someuser/.idgen/workerid/default-app
     * windows : C:\Users\someuser\.idgen\workerid\default-app
     *
     * @return
     */
    private static String getCacheFileName(String appName) {
        return System.getProperty("user.home") + File.separator + ".idgen" + File.separator + "workerid" + File.separator + appName + ".cache";
    }

    public static void writeCache(String appName, Object data) {
        try {
            File file = new File(getCacheFileName(appName));
            LogUtil.info(log, "workerid缓存成功：path={}", file);
            FileUtils.writeByteArrayToFile(file, JavaSerializer.serialize(data));
        } catch (Exception ex) {
            LogUtil.error(log, "workerid缓存写入失败,msg={},file={}", ex.getMessage(), ex);
        }
    }

    public static Object getDataFromFile(String appName) {
        try {
            File file = new File(getCacheFileName(appName));
            byte[] data = FileUtils.readFileToByteArray(file);
            if (data != null) {
                return JavaSerializer.deserialize(data);
            }
        } catch (Exception ex) {
            LogUtil.error(log, "workerid缓存读取失败,msg={},file={}", ex.getMessage(), ex);
        }
        return null;
    }
}
