/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.lock;

import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.lock.DistributedLock;
import com.fshows.fsframework.extend.lock.exception.RedisLockException;
import com.fshows.fsframework.extend.redis.RedisCache;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisDistributedLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLock.class);
    private static final long DEFAULT_LEASE_TIME = 15000L;
    private static final long DEFAULT_WAIT_TIME = 2000L;
    private static final String DEFAULT_ERROR_LOG = "\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff01 \u8017\u65f6 = {} ,lockKey = {}";
    private RedisCache redisCache;

    public RedisDistributedLock(RedisCache redisCache) {
        this.redisCache = redisCache;
    }

    @Override
    public void lock(String lockKey) {
        long currentTime = System.currentTimeMillis();
        try {
            this.redisCache.getRedisLock(lockKey).lock(15000L, TimeUnit.MILLISECONDS);
            LogUtil.info((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff01 \u8017\u65f6 = {} \uff0clockKey = {}", (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)DEFAULT_ERROR_LOG, (Throwable)e, (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
            throw new RedisLockException(MessageFormat.format("lock error, key={0}", lockKey), e);
        }
    }

    @Override
    public boolean tryLock(String lockKey) {
        return this.tryLock(lockKey, 2000L);
    }

    @Override
    public boolean tryLock(String lockKey, long timeout) {
        boolean isLock = false;
        long currentTime = System.currentTimeMillis();
        try {
            isLock = this.redisCache.getRedisLock(lockKey).tryLock(timeout, 15000L, TimeUnit.MILLISECONDS);
            LogUtil.info((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff01 \u8017\u65f6 = {} \uff0clockKey = {}", (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
            return isLock;
        }
        catch (InterruptedException e) {
            LogUtil.warn((Logger)log, (String)DEFAULT_ERROR_LOG, (Throwable)e, (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
            Thread.currentThread().interrupt();
            return isLock;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)DEFAULT_ERROR_LOG, (Throwable)e, (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
            throw new RedisLockException(MessageFormat.format("trylock error, key={0}", lockKey), e);
        }
    }

    @Override
    public void unlock(String lockKey) {
        long currentTime = System.currentTimeMillis();
        try {
            this.redisCache.getRedisLock(lockKey).unlock();
            LogUtil.info((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u5206\u5e03\u5f0f\u9501\u89e3\u9501\u6210\u529f\uff01 \u8017\u65f6 = {} \uff0clockKey = {}", (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u5206\u5e03\u5f0f\u9501\u89e3\u9501\u5931\u8d25\uff01 \u8017\u65f6 = {} ,lockKey = {}", (Throwable)e, (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockKey});
            throw new RedisLockException(MessageFormat.format("unlock error, key={0}", lockKey), e);
        }
    }
}

