/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.mq.core;

import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.aliyun.mq.config.FsMqConfig;
import com.fshows.fsframework.extend.aliyun.mq.core.FsMqInstanceManager;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApolloMqConfigListener {
    private static final Logger log = LoggerFactory.getLogger(ApolloMqConfigListener.class);
    @Autowired
    private FsMqInstanceManager instanceManager;
    @Autowired
    private FsMqConfig fsMqConfig;

    @ApolloConfigChangeListener
    public void onConfigChange(ConfigChangeEvent changeEvent) {
        if (!this.fsMqConfig.getMqClientDynamicUpdate().booleanValue()) {
            LogUtil.debug((Logger)log, (String)"MQ\u5ba2\u6237\u7aef\u52a8\u6001\u66f4\u65b0\u672a\u542f\u7528\uff0c\u5ffd\u7565\u914d\u7f6e\u53d8\u66f4");
            return;
        }
        Set<String> watchKeys = this.fsMqConfig.getWatchKeys();
        boolean needUpdate = false;
        for (String changeKey : changeEvent.changedKeys()) {
            ConfigChange change = changeEvent.getChange(changeKey);
            if (!watchKeys.contains(change.getPropertyName())) continue;
            LogUtil.info((Logger)log, (String)"\u68c0\u6d4b\u5230MQ\u76f8\u5173\u914d\u7f6e\u53d8\u66f4: {} = {} -> {}", (Object[])new Object[]{change.getPropertyName(), change.getOldValue(), change.getNewValue()});
            needUpdate = true;
        }
        if (needUpdate) {
            LogUtil.info((Logger)log, (String)"\u5f00\u59cb\u66f4\u65b0MQ\u5b9e\u4f8b...");
            CompletableFuture.runAsync(() -> {
                try {
                    this.instanceManager.updateAllProducers();
                    this.instanceManager.updateAllConsumers();
                    LogUtil.info((Logger)log, (String)"MQ\u5b9e\u4f8b\u66f4\u65b0\u5b8c\u6210\uff0cProducer: {}\u4e2a, Consumer: {}\u4e2a", (Object[])new Object[]{this.instanceManager.getProducerCount(), this.instanceManager.getConsumerCount()});
                }
                catch (Exception e) {
                    LogUtil.error((Logger)log, (String)"MQ\u5b9e\u4f8b\u66f4\u65b0\u5931\u8d25", (Throwable)e);
                }
            }).exceptionally(throwable -> {
                LogUtil.error((Logger)log, (String)"MQ\u5b9e\u4f8b\u66f4\u65b0\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)throwable);
                return null;
            });
        }
    }
}

