/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.util;

import com.fshows.fsframework.common.exception.CommonException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

public class ConfigUtil {
    public static final String DYNAMIC_PROPERTY_PREFIX = "${";
    public static final String DYNAMIC_PROPERTY_PREFIX2 = "#{";
    public static final String DYNAMIC_PROPERTY_SUFFIX = "}";
    public static final String ALIYUN_DOMAIN_NAME = "aliyuncs.com";
    public static final String NONE = "none";

    public static String getProperty(String el, ApplicationContext ctx) {
        if (ConfigUtil.isDynamicProperty(el)) {
            String result = ctx.getEnvironment().resolveRequiredPlaceholders(el);
            return ConfigUtil.isDynamicProperty(result) ? null : result;
        }
        return el;
    }

    public static <T> T getProperty(String el, Class<T> targetType, ApplicationContext ctx) {
        if (el == null) {
            return null;
        }
        String value = ConfigUtil.getProperty(el, ctx);
        if (targetType == String.class) {
            return (T)value;
        }
        if (targetType == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (targetType == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (targetType == Long.class) {
            return (T)Long.valueOf(value);
        }
        throw CommonException.SYSTEM_ERROR.newInstance("spring\u914d\u7f6e\u83b7\u53d6\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b\uff1a" + value, new Object[0]);
    }

    public static boolean isDynamicProperty(String key) {
        if (StringUtils.startsWithIgnoreCase((String)key, (String)DYNAMIC_PROPERTY_PREFIX2) && StringUtils.endsWithIgnoreCase((String)key, (String)DYNAMIC_PROPERTY_SUFFIX)) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase((String)key, (String)DYNAMIC_PROPERTY_PREFIX) && StringUtils.endsWithIgnoreCase((String)key, (String)DYNAMIC_PROPERTY_SUFFIX);
    }

    public static String getDynamicConfigKey(String el) {
        return ConfigUtil.isDynamicProperty(el) ? el : null;
    }

    public static String getDynamicKey(String key) {
        if (ConfigUtil.isDynamicProperty(key)) {
            int i = key.indexOf(":");
            if (i > -1) {
                return key.substring(2, i);
            }
            return key.substring(2, key.length() - 1);
        }
        return null;
    }
}

