/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package
        com.fshows.fsframework.extend.lock;

import com.fshows.fsframework.extend.lock.exception.LockException;

/**
 * 分布式的锁服务
 *
 * @author Liluqing
 * @version DistributedLockService.java, v 0.1 2018-10-18 10:50
 */
public interface DistributedLock {

    /**
     * 获取锁，如遇锁竞争则阻塞直到获取到锁
     *
     * @param lockKey 锁的key
     * @throws LockException 中间件异常（redis、zokeeper）、网络异常、线程中断
     */
    void lock(String lockKey);

    /**
     * 尝试获取锁，并立即返回结果
     *
     * @param lockKey 锁的key
     * @return 是否获取到锁
     * @throws LockException 中间件异常（redis、zokeeper）、网络异常、线程中断
     */
    boolean tryLock(String lockKey);

    /**
     * 在指定的时间内尝试获取锁
     *
     * @param lockKey 锁的key
     * @param timeout 获取锁的超时时间,单位毫秒
     * @return 是否获取到锁
     * @throws LockException 中间件异常（redis、zokeeper）、网络异常、线程中断
     */
    boolean tryLock(String lockKey, long timeout);

    /**
     * 解锁
     *
     * @param lockKey 锁的key
     * @throws LockException 中间件异常（redis、zokeeper）、网络异常、线程中断
     */
    void unlock(String lockKey);
}