/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.oss;

import com.alibaba.fastjson.JSON;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.fshows.fsframework.common.exception.CommonException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import java.io.File;
import java.net.URL;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunOssNonsingletonUtil {
    private static final Logger log = LoggerFactory.getLogger(AliyunOssNonsingletonUtil.class);
    private static final String BACKSLASH = "/";
    private OSSClient ossClient;
    private String bucketName;

    private AliyunOssNonsingletonUtil() {
    }

    public AliyunOssNonsingletonUtil(String endpoint, String bucketName, String accessKey, String secretKey) {
        this.bucketName = bucketName;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMaxConnections(200);
        conf.setSocketTimeout(10000);
        conf.setConnectionTimeout(10000);
        conf.setConnectionRequestTimeout(1000);
        conf.setIdleConnectionTime(10000L);
        conf.setMaxErrorRetry(3);
        conf.setSupportCname(true);
        conf.setSLDEnabled(false);
        conf.setProtocol(Protocol.HTTP);
        this.ossClient = new OSSClient(endpoint, accessKey, secretKey, conf);
    }

    public boolean uploadFile(String folder, File file) {
        if (file == null) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("file must be not null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)folder)) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{folder, file.getName()});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("folder param must be not null", new Object[0]);
        }
        if (file.isDirectory()) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{folder, file.getName()});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("file must be one file", new Object[0]);
        }
        long now = SystemClock.millisClock().now();
        String objectName = folder.lastIndexOf(BACKSLASH) != -1 ? folder : folder + BACKSLASH;
        objectName = this.checkObjectName(objectName);
        objectName = objectName + file.getName();
        LogUtil.info((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{objectName, file.getAbsolutePath()});
        PutObjectResult result = this.ossClient.putObject(this.bucketName, objectName, file);
        LogUtil.info((Logger)log, (String)"upload objectName:{},oss\u8fd4\u56de\u7ed3\u679c:{},\u8017\u65f6:{}ms", (Object[])new Object[]{objectName, JSON.toJSONString((Object)result), SystemClock.millisClock().now() - now});
        return result != null;
    }

    public boolean uploadFile(String folder, String localFile) {
        if (StringUtils.isEmpty((CharSequence)folder)) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{folder, localFile});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("folder param must be not null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)localFile)) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{folder, localFile});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("localFile param must be not null", new Object[0]);
        }
        File file = new File(localFile);
        if (file.isDirectory()) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{folder, localFile});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("localFile must be one file", new Object[0]);
        }
        long now = SystemClock.millisClock().now();
        String objectName = folder.lastIndexOf(BACKSLASH) != -1 ? folder : folder + BACKSLASH;
        objectName = this.checkObjectName(objectName);
        objectName = objectName + file.getName();
        LogUtil.info((Logger)log, (String)"oss\u4e0a\u4f20\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{objectName, localFile});
        PutObjectResult result = this.ossClient.putObject(this.bucketName, objectName, file);
        LogUtil.info((Logger)log, (String)"upload objectName:{},oss\u8fd4\u56de\u7ed3\u679c:{},\u8017\u65f6:{}ms", (Object[])new Object[]{objectName, JSON.toJSONString((Object)result), SystemClock.millisClock().now() - now});
        return result != null;
    }

    public boolean downloadFile(String objectName, String localFile) {
        if (StringUtils.isEmpty((CharSequence)objectName)) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0b\u8f7d\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{objectName, localFile});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("objectName param must be not null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)localFile)) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0b\u8f7d\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{objectName, localFile});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("localFile param must be not null", new Object[0]);
        }
        objectName = this.checkObjectName(objectName);
        long now = SystemClock.millisClock().now();
        ObjectMetadata metadata = this.ossClient.getObject(new GetObjectRequest(this.bucketName, objectName), new File(localFile));
        LogUtil.info((Logger)log, (String)"download objectName:{},Request-ID:{},\u8017\u65f6:{}ms", (Object[])new Object[]{objectName, metadata.getRequestId(), SystemClock.millisClock().now() - now});
        return metadata != null;
    }

    public boolean downloadFile(String objectName, File file) {
        if (file == null) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("file must be not null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)objectName)) {
            LogUtil.warn((Logger)log, (String)"oss\u4e0b\u8f7d\u7684objectName:{},localFile\uff1a{}", (Object[])new Object[]{objectName, file.getName()});
            throw CommonException.INVALID_PARAM_ERROR.newInstance("objectName param must be not null", new Object[0]);
        }
        objectName = this.checkObjectName(objectName);
        long now = SystemClock.millisClock().now();
        ObjectMetadata metadata = this.ossClient.getObject(new GetObjectRequest(this.bucketName, objectName), file);
        LogUtil.info((Logger)log, (String)"download objectName:{},Request-ID:{},\u8017\u65f6:{}ms", (Object[])new Object[]{objectName, metadata.getRequestId(), SystemClock.millisClock().now() - now});
        return metadata != null;
    }

    private String checkObjectName(String objectName) {
        if (objectName.startsWith(BACKSLASH)) {
            objectName = objectName.substring(1, objectName.length());
        }
        return objectName;
    }

    public void deleteFile(String objectName) {
        if (StringUtils.isEmpty((CharSequence)objectName)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("objectName param must be not null", new Object[0]);
        }
        objectName = this.checkObjectName(objectName);
        long now = SystemClock.millisClock().now();
        this.ossClient.deleteObject(this.bucketName, objectName);
        LogUtil.info((Logger)log, (String)"delete objectName:{},\u8017\u65f6:{}ms", (Object[])new Object[]{objectName, SystemClock.millisClock().now() - now});
    }

    public String getExpireUrl(String key, Integer expireSeconds) {
        if (StringUtils.isEmpty((CharSequence)key) || expireSeconds == null) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance(" key or expireSeconds  must be not null", new Object[0]);
        }
        Long expireMills = (long)expireSeconds.intValue() * 1000L;
        Long expireTime = System.currentTimeMillis() + expireMills;
        Date time = new Date(expireTime);
        return this.getExpireUrl(key, time);
    }

    public String getExpireUrl(String key, Date time) {
        if (StringUtils.isEmpty((CharSequence)key) || time == null) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance(" key or time  must be not null", new Object[0]);
        }
        String downloadUrl = "";
        try {
            URL url = this.ossClient.generatePresignedUrl(this.bucketName, key, time);
            downloadUrl = url.toString();
            return downloadUrl;
        }
        catch (ClientException e) {
            LogUtil.error((Logger)log, (String)"AliyunOssUtil >> fileUrl \u4e0b\u8f7d\u5730\u5740\u5f02\u5e38", (Throwable)e);
            return downloadUrl;
        }
    }

    public String getExpirePutUrl(String key, Integer expireSeconds) {
        if (StringUtils.isBlank((CharSequence)key) || expireSeconds == null) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance(" key or time  must not be null", new Object[0]);
        }
        String uploadUrl = "";
        try {
            GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, key, HttpMethod.PUT);
            Long expireMills = (long)expireSeconds.intValue() * 1000L;
            Long expireTime = System.currentTimeMillis() + expireMills;
            Date time = new Date(expireTime);
            request.setExpiration(time);
            request.setContentType("application/octet-stream");
            URL signedUrl = this.ossClient.generatePresignedUrl(request);
            uploadUrl = signedUrl.toString();
            return uploadUrl;
        }
        catch (ClientException e) {
            LogUtil.error((Logger)log, (String)"AliyunOssUtil >> getExpirePutUrl \u751f\u6210\u4e0a\u4f20url\u5f02\u5e38 >> Ex={}", (Object[])new Object[]{ExceptionUtils.getStackTrace((Throwable)e)});
            return uploadUrl;
        }
    }
}

