/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.mq.decorator;

import com.aliyun.openservices.ons.api.Consumer;
import com.aliyun.openservices.ons.api.ExpressionType;
import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.MessageSelector;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.aliyun.openservices.ons.api.bean.SubscriptionExt;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.aliyun.mq.config.FsMqConfig;
import com.fshows.fsframework.extend.aliyun.mq.core.FsMqInstanceManager;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FsConsumerBean
implements Consumer {
    private static final Logger log = LoggerFactory.getLogger(FsConsumerBean.class);
    private Properties properties;
    private Map<Subscription, MessageListener> subscriptionTable;
    private Consumer consumer;
    private String instanceKey;
    @Autowired
    private FsMqInstanceManager instanceManager;
    @Autowired
    private FsMqConfig fsMqConfig;

    public void start() {
        if (null == this.instanceManager) {
            throw new ONSClientException("\u5f53\u524d FsConsumerBean \u5bf9\u8c61\uff0c\u672a\u901a\u8fc7 @Bean \u6ce8\u89e3\u6ce8\u518c\u5230Spring\u5bb9\u5668\u4e2d, \u542f\u52a8\u5931\u8d25");
        }
        if (null == this.fsMqConfig) {
            throw new ONSClientException("\u5f53\u524d FsConsumerBean \u5bf9\u8c61\uff0c\u672a\u901a\u8fc7 @Bean \u6ce8\u89e3\u6ce8\u518c\u5230Spring\u5bb9\u5668\u4e2d, \u542f\u52a8\u5931\u8d25");
        }
        if (null == this.properties) {
            throw new ONSClientException("properties not set");
        }
        if (null == this.subscriptionTable) {
            throw new ONSClientException("subscriptionTable not set");
        }
        this.validateCredentials();
        Properties updatedProperties = this.updatePropertiesWithDecryptedKeys();
        this.consumer = ONSFactory.createConsumer((Properties)updatedProperties);
        this.subscribeTopics();
        this.consumer.start();
        this.instanceKey = this.generateInstanceKey();
        if (this.instanceManager != null && this.fsMqConfig != null && this.fsMqConfig.getMqClientDynamicUpdate().booleanValue()) {
            this.instanceManager.registerConsumer(this.instanceKey, this, this.properties, this.subscriptionTable);
        }
        LogUtil.info((Logger)log, (String)"FsConsumerBean\u542f\u52a8\u5b8c\u6210: {}", (Object[])new Object[]{this.instanceKey});
    }

    public synchronized void replaceConsumerInstance(Consumer newConsumer, Map<Subscription, MessageListener> subscriptionTable) {
        this.consumer = newConsumer;
        this.subscriptionTable = subscriptionTable;
        LogUtil.info((Logger)log, (String)"Consumer\u5b9e\u4f8b\u5df2\u66ff\u6362: {}", (Object[])new Object[]{this.instanceKey});
    }

    public void shutdown() {
        if (this.instanceManager != null && this.instanceKey != null) {
            this.instanceManager.unregisterConsumer(this.instanceKey);
        }
        if (this.consumer != null) {
            this.consumer.shutdown();
        }
        LogUtil.info((Logger)log, (String)"FsConsumerBean\u5df2\u5173\u95ed: {}", (Object[])new Object[]{this.instanceKey});
    }

    @PreDestroy
    public void preDestroy() {
        this.shutdown();
    }

    public void updateCredential(Properties credentialProperties) {
        if (this.consumer != null) {
            this.consumer.updateCredential(credentialProperties);
        }
    }

    public void subscribe(String topic, String subExpression, MessageListener listener) {
        if (null == this.consumer) {
            throw new ONSClientException("subscribe must be called after consumerBean started");
        }
        this.consumer.subscribe(topic, subExpression, listener);
    }

    public void subscribe(String topic, MessageSelector selector, MessageListener listener) {
        if (null == this.consumer) {
            throw new ONSClientException("subscribe must be called after consumerBean started");
        }
        this.consumer.subscribe(topic, selector, listener);
    }

    public void unsubscribe(String topic) {
        if (null == this.consumer) {
            throw new ONSClientException("unsubscribe must be called after consumerBean started");
        }
        this.consumer.unsubscribe(topic);
    }

    public boolean isStarted() {
        return this.consumer != null && this.consumer.isStarted();
    }

    public boolean isClosed() {
        return this.consumer == null || this.consumer.isClosed();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<Subscription, MessageListener> getSubscriptionTable() {
        return this.subscriptionTable;
    }

    public void setSubscriptionTable(Map<Subscription, MessageListener> subscriptionTable) {
        this.subscriptionTable = subscriptionTable;
    }

    private void subscribeTopics() {
        block2: for (Map.Entry<Subscription, MessageListener> next : this.subscriptionTable.entrySet()) {
            Subscription subscription;
            if ("com.aliyun.openservices.ons.api.impl.notify.ConsumerImpl".equals(this.consumer.getClass().getCanonicalName()) && next.getKey() instanceof SubscriptionExt) {
                subscription = (SubscriptionExt)next.getKey();
                for (Method method : this.consumer.getClass().getMethods()) {
                    if (!"subscribeNotify".equals(method.getName())) continue;
                    try {
                        method.invoke((Object)this.consumer, subscription.getTopic(), subscription.getExpression(), subscription.isPersistence(), next.getValue());
                        continue block2;
                    }
                    catch (Exception e) {
                        throw new ONSClientException("subscribeNotify invoke exception", (Throwable)e);
                    }
                }
                continue;
            }
            subscription = next.getKey();
            if (subscription.getType() == null || ExpressionType.TAG.name().equals(subscription.getType())) {
                this.subscribe(subscription.getTopic(), subscription.getExpression(), next.getValue());
                continue;
            }
            if (ExpressionType.SQL92.name().equals(subscription.getType())) {
                this.subscribe(subscription.getTopic(), MessageSelector.bySql((String)subscription.getExpression()), next.getValue());
                continue;
            }
            throw new ONSClientException(String.format("Expression type %s is unknown!", subscription.getType()));
        }
    }

    private Properties updatePropertiesWithDecryptedKeys() {
        Properties updatedProperties = new Properties();
        updatedProperties.putAll((Map<?, ?>)this.properties);
        if (this.fsMqConfig != null && this.fsMqConfig.getMqClientDynamicUpdate().booleanValue()) {
            updatedProperties.setProperty("AccessKey", this.fsMqConfig.getDecryptedAccessKey());
            updatedProperties.setProperty("SecretKey", this.fsMqConfig.getDecryptedSecretKey());
        }
        return updatedProperties;
    }

    private void validateCredentials() {
        String accessKey = this.properties.getProperty("AccessKey");
        String secretKey = this.properties.getProperty("SecretKey");
        if (accessKey != null || secretKey != null) {
            String consumerId = this.properties.getProperty("ConsumerId");
            if (StringUtils.isBlank((CharSequence)consumerId)) {
                consumerId = this.properties.getProperty("GROUP_ID");
            }
            String errorMsg = String.format("%s\u6d88\u8d39\u8005\u5b9e\u4f8b\u542f\u52a8\u5931\u8d25\uff0c\u963f\u91cc\u4e91ak\u548csk\u8bbe\u7f6e\u5fc5\u987b\u4e3a\u7a7a\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u4f7f\u7528\u7edf\u4e00\u914d\u7f6eak/sk\u914d\u7f6e", consumerId);
            LogUtil.error((Logger)log, (String)errorMsg);
            throw new ONSClientException(errorMsg);
        }
    }

    private String generateInstanceKey() {
        return "consumer_" + System.identityHashCode(this) + "_" + System.currentTimeMillis();
    }
}

