/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fsframework.extend.util;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.symmetric.AES;

import java.nio.charset.StandardCharsets;

/**
 * @author wangqilei
 * @version FsAESUtil.java, v 0.1 2024-12-11 3:53 PM wangqilei
 */
public class FsAESUtil {

    /**
     * 对AES的密码进行加密
     * 规则：两次MD5加密
     *
     * @param pwd
     * @return
     */
    public static byte[] generateAESPwd(String pwd) {
        return DigestUtil.md5(DigestUtil.md5(pwd.getBytes(StandardCharsets.UTF_8)));
    }

    /**
     * AES解密
     *
     * @param ciphertext
     * @param pwd
     * @return
     */
    public static String decryptKey(String ciphertext, String pwd) {
        AES aes = SecureUtil.aes(generateAESPwd(pwd));
        return new String(aes.decrypt(ciphertext));
    }
}