/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.extension;

import cn.hutool.core.util.ObjectUtil;
import com.fshows.fsframework.core.utils.LogUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 扩展点注册库
 *
 * @author liangyuanping
 * @version ExtensionRepository.java, v 0.1 2022-07-16 4:10 下午 liangyuanping
 */
@Component
@Slf4j
public class ExtensionRepository {

    /**
     * 扩展点注册库容器
     */
    private Map<String, ExtensionCoordinate> extensionRepository = new ConcurrentHashMap<>();

    /**
     * 注册扩展点
     *
     * @param extensionCoordinate
     */
    public void register(ExtensionCoordinate extensionCoordinate) {
        BusinessScenario businessScenario = extensionCoordinate.getBusinessScenario();
        ExtensionCoordinate oldCoordinate = extensionRepository.put(businessScenario.getUniqueIdentity(), extensionCoordinate);
        if (ObjectUtil.isNotNull(oldCoordinate)) {
            throw new RuntimeException(String.format("Duplicate registration is not allowed for :%s", extensionCoordinate));
        }
    }

    /**
     * 获取扩展点注册库容器
     *
     * @param businessScenario
     * @return
     */
    public ExtensionCoordinate get(BusinessScenario businessScenario) {
        ExtensionCoordinate coordinate = extensionRepository.get(businessScenario.getUniqueIdentity());
        if (coordinate == null) {
            LogUtil.error(log,"获取业务场景扩展点实现失败，失败原因：尚未定义该业务场景相关扩展点。{}", businessScenario);
            throw new RuntimeException("尚未定义该业务场景相关扩展点 [" + businessScenario + "]");
        }
        return coordinate;
    }

    public Map<String, ExtensionCoordinate> getAll() {
        return extensionRepository;
    }
}