/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fsframework.extend.dubbo.qos;

import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.qos.command.BaseCommand;
import com.alibaba.dubbo.qos.command.CommandContext;
import com.alibaba.dubbo.qos.command.annotation.Cmd;
import com.alibaba.dubbo.qos.command.impl.Online;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

import java.util.Map;

/**
 * 重新dubbo qos默认的offline命令，增加关闭MQ消费者操作
 *
 * @author Liluqing
 * @version FsOnline.java, v 0.1 2020-01-08 11:04
 */
@Cmd(name = "online", summary = "online dubbo", example = {
        "online dubbo",
        "online xx.xx.xxx.service"
})
public class FsOnline extends Online implements BaseCommand {

    /**
     * 全部服务
     */
    private final static String ALL_SERVICE = ".*";

    /**
     * 命令是否执行成功
     */
    private final static String OK = "OK";

    @Override
    public String execute(CommandContext commandContext, String[] args) {
        String servicePattern = ALL_SERVICE;
        if (args != null && args.length > 0) {
            servicePattern = args[0];
        }
        String resultStr =  super.execute(commandContext, args);
        // 不是上线所有dubbo服务或者服务上线失败时，不再进行后续的MQ关闭处理
        if (!StringUtils.equals(servicePattern, ALL_SERVICE) || !StringUtils.equals(resultStr, OK)) {
            return resultStr;
        }
        // 关闭MQ消费者
        startMqConsumer();
        return OK;
    }

    /**
     * 启动MQ消费者
     */
    private void startMqConsumer() {
        // 获取spring上下文
        ApplicationContext applicationContext = ServiceBean.getSpringContext();
        if (applicationContext == null) {
            return;
        }
        // 获取MQ消费者对象
        Map<String, ConsumerBean> map = applicationContext.getBeansOfType(ConsumerBean.class);
        if (map == null || map.size() == 0) {
            return;
        }
        // 遍历关闭MQ消费者
        for (ConsumerBean c : map.values()) {
            if (c == null || c.isStarted()) {
                continue;
            }
            c.start();
        }
    }
}