/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.loadbalance;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.cluster.loadbalance.RandomLoadBalance;
import com.alibaba.fastjson.JSON;
import com.beust.jcommander.internal.Lists;
import com.fshows.fsframework.core.utils.LogUtil;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableLoadBalance
extends RandomLoadBalance {
    private static final Logger log = LoggerFactory.getLogger(StableLoadBalance.class);
    public static final String NAME = "stable";
    public static final String ROUTE_TAG_CONTEXT_KEY = "ROUTE_TAG_CONTEXT_KEY";
    public static final String STABLE_ROUTE_TAG_KEY = "stable.route.tag";
    public static final String DEFAULT_ROUTE_TAG_KEY = "dubbo.provider.parameters.route";
    private static final String DUBBO_DEFAULT_ROUTE_TAG_KEY = "default.route";
    private static final String DUBBO_ROUTE_TAG_KEY = "route";

    public <T> Invoker<T> select(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        return this.doSelect(invokers, url, invocation);
    }

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        LogUtil.debug((Logger)log, (String)"doSelect >> \u8def\u7531\u8fc7\u6ee4\u5f00\u59cb >> invokers = {}, invocation = {}", (Object[])new Object[]{JSON.toJSONString(invokers), invocation});
        String sourceOwnerByContext = this.getRouteTagByContext();
        List<Invoker<T>> filterInvokersByGroup = this.filterInvokersByContextRouteTag(invokers, sourceOwnerByContext);
        if (StrUtil.isBlank((CharSequence)sourceOwnerByContext) || filterInvokersByGroup.isEmpty()) {
            filterInvokersByGroup = this.filterInvokersByStableRouteTag(invokers);
        }
        if (!filterInvokersByGroup.isEmpty()) {
            invokers = filterInvokersByGroup;
        }
        LogUtil.debug((Logger)log, (String)"doSelect >> \u8def\u7531\u8fc7\u6ee4\u7ed3\u675f >> invokers = {}, invocation = {}", (Object[])new Object[]{JSON.toJSONString(invokers), invocation});
        return super.doSelect(invokers, url, invocation);
    }

    private <T> List<Invoker<T>> filterInvokersByStableRouteTag(List<Invoker<T>> invokers) {
        List<Invoker<T>> result = invokers.stream().filter(this::isStableRouteTag).collect(Collectors.toList());
        LogUtil.debug((Logger)log, (String)"filterInvokersByStableRouteTag >> \u6839\u636e stable route tag \u8fc7\u6ee4 >> invokers = {}", (Object[])new Object[]{JSON.toJSONString(invokers)});
        return result;
    }

    private <T> boolean isStableRouteTag(Invoker<T> it) {
        return this.isMatchExpectRouteTag(it, System.getProperty(STABLE_ROUTE_TAG_KEY));
    }

    private <T> boolean isMatchExpectRouteTag(Invoker<T> it, String expectRouteTag) {
        return StrUtil.equalsIgnoreCase((CharSequence)this.getProviderRouteTagByDubboInvoker(it), (CharSequence)expectRouteTag);
    }

    private <T> List<Invoker<T>> filterInvokersByContextRouteTag(List<Invoker<T>> invokers, String sourceOwnerByContext) {
        List<Invoker<T>> result = Lists.newArrayList();
        if (StrUtil.isNotBlank((CharSequence)sourceOwnerByContext)) {
            result = invokers.stream().filter(it -> this.isMatchExpectRouteTag((Invoker)it, sourceOwnerByContext)).collect(Collectors.toList());
        }
        LogUtil.debug((Logger)log, (String)"doSelect >> \u6839\u636e\u4e0a\u4e0b\u6587\u8def\u7531 TAG \u8fc7\u6ee4\u8c03\u7528\u5217\u8868 >> sourceOwnerByContext = {}\uff0c result = {}", (Object[])new Object[]{JSON.toJSONString((Object)sourceOwnerByContext), JSON.toJSONString(result)});
        return result;
    }

    private <T> String getProviderRouteTagByDubboInvoker(Invoker<T> invoker) {
        if (Objects.isNull(invoker)) {
            return "";
        }
        URL url = invoker.getUrl();
        if (Objects.isNull(url)) {
            return "";
        }
        String routeTag = url.getParameter(DUBBO_ROUTE_TAG_KEY);
        if (StrUtil.isNotBlank((CharSequence)routeTag)) {
            return routeTag;
        }
        return url.getParameter(DUBBO_DEFAULT_ROUTE_TAG_KEY, "");
    }

    private String getRouteTagByContext() {
        String result = RpcContext.getContext().getAttachment(ROUTE_TAG_CONTEXT_KEY);
        LogUtil.debug((Logger)log, (String)"doSelect >> \u83b7\u5f97\u4e0a\u4e0b\u6587\u8def\u7531 TAG >> result = {}", (Object[])new Object[]{result});
        if (StrUtil.isBlank((CharSequence)result) && StrUtil.isNotBlank((CharSequence)(result = System.getProperty(DEFAULT_ROUTE_TAG_KEY)))) {
            RpcContext.getContext().setAttachment(ROUTE_TAG_CONTEXT_KEY, result);
            LogUtil.debug((Logger)log, (String)"doSelect >> \u4e0a\u4e0b\u6587\u8def\u7531 TAG \u4e3a\u7a7a,\u4ece\u73af\u5883\u53d8\u91cf\u4e2d\u53d6\uff0c\u5e76\u8bbe\u7f6e\u5230\u4e0a\u4e0b\u6587\u4e2d >> result = {}", (Object[])new Object[]{result});
        }
        return result;
    }
}

