/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.dubbo.model.DubboThreadPoolMonitorConfigConvertModel;
import com.fshows.fsframework.extend.dubbo.model.DubboThreadPoolMonitorConfigModel;
import com.fshows.fsframework.extend.util.SpringContextUtil;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Activate(group={"provider"}, order=-9999)
public class GlobalDubboThreadPoolMonitor
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalDubboThreadPoolMonitor.class);
    private static final String DUBBO_THREAD_POOL_MONITOR_SWITCH = "dubbo.thread.pool.monitor.switch";
    private static final String DUBBO_THREAD_POOL_MONITOR_CONFIG = "dubbo.thread.pool.monitor.config";
    private static final String DUBBO_PROTOCOL_THREADS = "dubbo.protocol.threads";
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);
    private final Queue<ScheduledFuture<?>> scheduledFutures = new ConcurrentLinkedQueue();
    private final Map<String, AtomicInteger> methodAndCountMap = new ConcurrentHashMap<String, AtomicInteger>();
    private static final AtomicLong LAST_ALERT_TIME = new AtomicLong(0L);
    private static final String DEFAULT_DUBBO_PROTOCOL_THREADS = "200";
    private static final BigDecimal EMERGENCY_THRESHOLD_RATIO = new BigDecimal("0.6");
    private static final BigDecimal HUNDRED = new BigDecimal("100");
    private static final Long ALERT_INTERVAL_MS = 10000L;
    private static volatile DubboThreadPoolMonitorConfigConvertModel configModel = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Environment environment = SpringContextUtil.getEnvironment();
        if (environment != null) {
            if ("1".equals(environment.getProperty(DUBBO_THREAD_POOL_MONITOR_SWITCH))) {
                DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigModel = null;
                try {
                    threadPoolMonitorConfigModel = this.getThreadPoolMonitorConfigModel();
                }
                catch (Throwable e) {
                    LogUtil.error((Logger)log, (String)"record thread-pool running get monitor config error >> dubbo\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u76d1\u63a7\uff0c\u52a0\u8f7d\u914d\u7f6e\u53c2\u6570\u5f02\u5e38", (Throwable)e);
                }
                if (threadPoolMonitorConfigModel != null) {
                    String methodName = invoker.getUrl().getPath() + "." + invocation.getMethodName();
                    this.methodAndCountMap.compute(methodName, (key, count) -> {
                        if (count == null) {
                            return new AtomicInteger(1);
                        }
                        count.incrementAndGet();
                        return count;
                    });
                    try {
                        Result result = invoker.invoke(invocation);
                        return result;
                    }
                    finally {
                        this.methodAndCountMap.compute(methodName, (key, count) -> {
                            if (count != null && count.decrementAndGet() == 0) {
                                return null;
                            }
                            return count;
                        });
                        this.alertIfEmergency(threadPoolMonitorConfigModel);
                    }
                }
            } else {
                configModel = null;
                this.cancelMonitorTask();
            }
        }
        return invoker.invoke(invocation);
    }

    private void alertIfEmergency(DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigModel) {
        int emergencyThreshold;
        int usageCount = this.methodAndCountMap.values().stream().mapToInt(AtomicInteger::get).sum();
        if (usageCount >= (emergencyThreshold = threadPoolMonitorConfigModel.getApplicationThreadCount().multiply(EMERGENCY_THRESHOLD_RATIO).setScale(2, RoundingMode.HALF_UP).intValue())) {
            long now = System.currentTimeMillis();
            long lastAlertTime = LAST_ALERT_TIME.getAndSet(now);
            if (lastAlertTime != 0L && now < lastAlertTime + ALERT_INTERVAL_MS) {
                return;
            }
            List methodAndCountList = this.methodAndCountMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(AtomicInteger::get)).reversed()).limit(200L).collect(Collectors.toList());
            LogUtil.error((Logger)log, (String)"record thread-pool running method >> \u7d27\u6025\u8b66\u62a5\uff0c\u7ebf\u7a0b\u6c60\u5360\u7528{}%\u4ee5\u4e0a\uff08\u4ec5\u8f93\u51fa\u524d200\u4e2a\u65b9\u6cd5\uff09>> usageCount={}, methodAndCountList={}", (Object[])new Object[]{EMERGENCY_THRESHOLD_RATIO.multiply(HUNDRED).setScale(0, RoundingMode.HALF_UP), usageCount, methodAndCountList});
        }
    }

    private void recordThreadPoolRunningMethod(BigDecimal applicationThreadCount, BigDecimal usageThresholdRatio) {
        try {
            int threshold;
            List methodAndCountList = this.methodAndCountMap.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.comparingInt(AtomicInteger::get)).reversed()).collect(Collectors.toList());
            int usageCount = methodAndCountList.stream().mapToInt(entry -> ((AtomicInteger)entry.getValue()).get()).sum();
            if (usageThresholdRatio != null && usageCount >= (threshold = applicationThreadCount.multiply(usageThresholdRatio).setScale(2, RoundingMode.HALF_UP).intValue())) {
                LogUtil.warn((Logger)log, (String)"record thread-pool running method >> dubbo\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u76d1\u63a7\uff0c\u8d85\u8fc7\u8bbe\u5b9a\u9608\u503c >> applicationThreadCount={}, usageCount={}, methodAndCountList={}", (Object[])new Object[]{applicationThreadCount, usageCount, methodAndCountList});
            }
            LogUtil.info((Logger)log, (String)"record thread-pool running method >> \u8f93\u51fadubbo\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5 >> usageCount={}, methodAndCountList={}", (Object[])new Object[]{usageCount, methodAndCountList});
        }
        catch (Throwable e) {
            LogUtil.error((Logger)log, (String)"record thread-pool running method error >> \u8f93\u51fadubbo\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DubboThreadPoolMonitorConfigConvertModel getThreadPoolMonitorConfigModel() {
        if (configModel == null) {
            GlobalDubboThreadPoolMonitor globalDubboThreadPoolMonitor = this;
            synchronized (globalDubboThreadPoolMonitor) {
                if (configModel == null) {
                    List<DubboThreadPoolMonitorConfigModel.ThreadPoolMonitorPointConfigModel> threadPoolMonitorPointConfigList;
                    DubboThreadPoolMonitorConfigModel config;
                    Environment environment = SpringContextUtil.getEnvironment();
                    if (environment == null) {
                        return null;
                    }
                    DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel();
                    String dubboProtocolThreads = StrUtil.blankToDefault((CharSequence)environment.getProperty(DUBBO_PROTOCOL_THREADS), (String)DEFAULT_DUBBO_PROTOCOL_THREADS);
                    threadPoolMonitorConfigConvertModel.setApplicationThreadCount(new BigDecimal(dubboProtocolThreads));
                    String threadPoolMonitorConfigStr = environment.getProperty(DUBBO_THREAD_POOL_MONITOR_CONFIG);
                    if (StrUtil.isNotBlank((CharSequence)threadPoolMonitorConfigStr) && (config = (DubboThreadPoolMonitorConfigModel)JSONObject.parseObject((String)threadPoolMonitorConfigStr, DubboThreadPoolMonitorConfigModel.class)) != null && CollUtil.isNotEmpty(threadPoolMonitorPointConfigList = config.getThreadPoolMonitorPointConfigModelList())) {
                        ArrayList threadPoolMonitorPointConfigConvertModelList = Lists.newArrayList();
                        for (DubboThreadPoolMonitorConfigModel.ThreadPoolMonitorPointConfigModel threadPoolMonitorPointConfigModel : threadPoolMonitorPointConfigList) {
                            String[] split;
                            if (!StrUtil.isNotBlank((CharSequence)threadPoolMonitorPointConfigModel.getMonitorPeriod()) || (split = threadPoolMonitorPointConfigModel.getMonitorPeriod().split("~")).length != 2) continue;
                            DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel threadPoolMonitorPointConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel();
                            threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse(split[0], DateTimeFormatter.ofPattern("HH:mm:ss")));
                            threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse(split[1], DateTimeFormatter.ofPattern("HH:mm:ss")));
                            threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(threadPoolMonitorPointConfigModel.getMonitorFrequency());
                            threadPoolMonitorPointConfigConvertModel.setUsageThresholdRatio(new BigDecimal(threadPoolMonitorPointConfigModel.getUsageThresholdRatio()));
                            threadPoolMonitorPointConfigConvertModelList.add(threadPoolMonitorPointConfigConvertModel);
                        }
                        threadPoolMonitorConfigConvertModel.setThreadPoolMonitorPointConfigList(threadPoolMonitorPointConfigConvertModelList);
                        this.startMonitorTask(threadPoolMonitorConfigConvertModel);
                    }
                    configModel = threadPoolMonitorConfigConvertModel;
                }
            }
        }
        return configModel;
    }

    private void startMonitorTask(DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigConvertModel) {
        if (threadPoolMonitorConfigConvertModel != null && CollUtil.isNotEmpty(threadPoolMonitorConfigConvertModel.getThreadPoolMonitorPointConfigList())) {
            for (DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel configConvertModel : threadPoolMonitorConfigConvertModel.getThreadPoolMonitorPointConfigList()) {
                LocalTime start = configConvertModel.getMonitorPeriodStartTime();
                LocalTime end = configConvertModel.getMonitorPeriodEndTime();
                long monitorFrequency = configConvertModel.getMonitorFrequency().intValue();
                long initialDelay = 0L;
                LocalTime nowTime = LocalTime.now();
                if (nowTime.isBefore(start)) {
                    initialDelay = nowTime.until(start, ChronoUnit.SECONDS);
                }
                ScheduledFuture<?> scheduledFuture = SCHEDULER.scheduleAtFixedRate(() -> {
                    try {
                        LocalTime now = LocalTime.now();
                        if (now.isAfter(start) && now.isBefore(end)) {
                            this.recordThreadPoolRunningMethod(threadPoolMonitorConfigConvertModel.getApplicationThreadCount(), configConvertModel.getUsageThresholdRatio());
                        }
                    }
                    catch (Throwable e) {
                        LogUtil.error((Logger)log, (String)"running thread-pool monitor task error >> \u8fd0\u884c\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u76d1\u63a7\u5f02\u5e38", (Throwable)e);
                    }
                }, initialDelay, monitorFrequency, TimeUnit.SECONDS);
                this.scheduledFutures.add(scheduledFuture);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelMonitorTask() {
        if (CollUtil.isNotEmpty(this.scheduledFutures)) {
            GlobalDubboThreadPoolMonitor globalDubboThreadPoolMonitor = this;
            synchronized (globalDubboThreadPoolMonitor) {
                if (CollUtil.isNotEmpty(this.scheduledFutures)) {
                    try {
                        ScheduledFuture<?> future;
                        while ((future = this.scheduledFutures.poll()) != null) {
                            if (future.isCancelled()) continue;
                            future.cancel(false);
                        }
                    }
                    catch (Throwable e) {
                        LogUtil.error((Logger)log, (String)"cancel thread-pool monitor task error >> \u53d6\u6d88\u7ebf\u7a0b\u6c60\u5360\u7528\u65b9\u6cd5\u76d1\u63a7\u5f02\u5e38", (Throwable)e);
                    }
                }
            }
        }
    }
}

