/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.extension.context;

import cn.hutool.core.util.StrUtil;
import com.fshows.fsframework.extend.extension.BusinessScenario;
import com.fshows.fsframework.extend.extension.IExtensionPoint;

import java.util.function.Consumer;
import java.util.function.Function;

/**
 * 执行器通用方法
 *
 * @author liangyuanping
 * @version AbstractComponentExecutor.java, v 0.1 2022-07-16 7:19 下午 liangyuanping
 */
public abstract class AbstractComponentExecutor {

    /**
     * 执行扩展组件，并返回执行结果
     *
     * @param businessScenario
     * @param targetClazz
     * @param function
     * @param <R>              Response Type
     * @param <T>              Parameter Type
     * @return
     */
    public <R, T extends IExtensionPoint> R execute(Class<T> targetClazz, BusinessScenario businessScenario, Function<T, R> function) {
        T component = locateComponent(targetClazz, businessScenario);
        return function.apply(component);
    }

    /**
     * 执行扩展点任务
     *
     * @param targetClazz      扩展点目标类
     * @param businessScenario 业务场景
     * @param exeFunction      函数式执行不返回响应结果
     * @param <T>              参数类型
     */
    public <T> void executeVoid(Class<T> targetClazz, BusinessScenario businessScenario, Consumer<T> exeFunction) {
        T component = locateComponent(targetClazz, businessScenario);
        exeFunction.accept(component);
    }

    /**
     * 根据场景获取扩展点Bean
     * @param targetClz
     * @param businessScenario
     * @param <T>
     * @return
     */
    public <T> T getExtensionBean(Class<T> targetClz,BusinessScenario businessScenario) {
        return locateComponent(targetClz, businessScenario);
    }

    /**
     * 根据场景值获取扩展点Bean
     * @param targetClz
     * @param scenario
     * @param <T>
     * @return
     */
    public <T> T getExtensionBean(Class<T> targetClz, String scenario) {
        if (StrUtil.isBlank(scenario)) {
            throw new RuntimeException("业务场景 scenario 不能为空");
        }
        BusinessScenario businessScenario = new BusinessScenario(scenario);
        return getExtensionBean(targetClz, businessScenario);
    }

    /**
     * 查找扩展点组件
     *
     * @param targetClz   扩展点目标类
     * @param bizScenario 业务场景
     * @param <C>         参数类型
     * @return 扩展点组件
     */
    protected abstract <C> C locateComponent(Class<C> targetClz, BusinessScenario bizScenario);
}