/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.transaction;

import com.fshows.fsframework.common.exception.BaseException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.transaction.FsTransactionManager;
import com.fshows.fsframework.extend.transaction.ServiceHandle;
import com.fshows.fsframework.extend.transaction.ServiceRollback;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class DefaultFsTransactionManager
implements FsTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultFsTransactionManager.class);
    private DataSourceTransactionManager transactionManager;

    @Override
    public <T> T execute(Supplier<T> serviceHandle, ServiceRollback serviceRollback) {
        T result;
        TransactionStatus transaction = null;
        try {
            transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            result = serviceHandle.get();
            this.transactionManager.commit(transaction);
        }
        catch (BaseException e) {
            this.serviceRollback(serviceRollback, transaction, (Exception)((Object)e));
            LogUtil.warn((Logger)log, (String)"\u4e1a\u52a1\u5f02\u5e38-\u4e8b\u52a1\u53d1\u751f\u56de\u6eda", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.serviceRollback(serviceRollback, transaction, e);
            LogUtil.error((Logger)log, (String)"\u7cfb\u7edf\u672a\u77e5\u9519\u8bef-\u4e8b\u52a1\u53d1\u751f\u56de\u6eda", (Throwable)e);
            throw e;
        }
        return result;
    }

    @Override
    public void executeNoReturn(ServiceHandle serviceHandle, ServiceRollback serviceRollback) {
        TransactionStatus transaction = null;
        try {
            transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            serviceHandle.handle();
            this.transactionManager.commit(transaction);
        }
        catch (BaseException e) {
            this.serviceRollback(serviceRollback, transaction, (Exception)((Object)e));
            LogUtil.warn((Logger)log, (String)"\u4e1a\u52a1\u5f02\u5e38-\u4e8b\u52a1\u53d1\u751f\u56de\u6eda", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            this.serviceRollback(serviceRollback, transaction, e);
            LogUtil.error((Logger)log, (String)"\u7cfb\u7edf\u4f4d\u7f6e\u9519\u8bef-\u4e8b\u52a1\u53d1\u751f\u56de\u6eda", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRollback(ServiceRollback serviceRollback, TransactionStatus transaction, Exception ex) {
        if (transaction == null) {
            return;
        }
        boolean isRollback = true;
        try {
            isRollback = serviceRollback.noException(ex);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u4e1a\u52a1\u56de\u6eda\u903b\u8f91\u5f02\u5e38-\u4e8b\u52a1\u53d1\u751f\u56de\u6eda", (Throwable)e);
        }
        finally {
            if (isRollback) {
                this.transactionManager.rollback(transaction);
            } else {
                this.transactionManager.commit(transaction);
            }
        }
    }

    public void setTransactionManager(DataSourceTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

