/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.idgen.impl;

import cn.hutool.core.util.RandomUtil;
import com.fshows.fsframework.core.utils.FsDateUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.idgen.exception.IdGenerateException;
import com.fshows.fsframework.extend.idgen.impl.FsSnowflakeIdConfig;
import com.fshows.fsframework.extend.idgen.worker.RandomWorkerIdAssigner;
import com.fshows.fsframework.extend.idgen.worker.WorkerIdAssigner;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;

public class FsSnowflakeIdGenerator {
    private static final int THROW_EX_TRUE = 0;
    private static final String MAX_DIGIT_STR = "9";
    private volatile String timeStr = null;
    private volatile long lastTimestamp = 0L;
    private long workId;
    private volatile long seq = 0L;
    private FsSnowflakeIdConfig config;
    private long maxSequence = -1L;
    private static String[] ZEROIZE_BUFFER = new String[]{"", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000", "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000"};
    private volatile long tailSeq = 0L;

    public FsSnowflakeIdGenerator(WorkerIdAssigner workerIdAssigner, FsSnowflakeIdConfig config) {
        this.workId = workerIdAssigner.assignWorkerId();
        long bitMaxWorkerId = (1L << config.getWorkerIdBits()) - 1L;
        if (this.workId > bitMaxWorkerId) {
            throw new IdGenerateException("workerId\u6709\u8bef,workerId\u4e0d\u80fd\u5927\u4e8e" + bitMaxWorkerId);
        }
        if (config.getNumberLength() > 18) {
            throw new IdGenerateException("numberLength\u4e0d\u80fd\u5927\u4e8e18\u4f4d");
        }
        this.config = config;
        this.maxSequence = this.getMaxSequence(config);
        this.tailSeq = this.maxSequence - 1L;
    }

    private long getMaxSequence(FsSnowflakeIdConfig config) {
        long bitMaxSeq = 1L << config.getSequenceBits();
        long bitMaxWorkerId = 1L << config.getWorkerIdBits();
        long numberLength = config.getNumberLength();
        long maxNumber = this.getMaxNumber(numberLength);
        long maxSeq = maxNumber / bitMaxWorkerId;
        return Math.min(maxSeq, bitMaxSeq);
    }

    private long getMaxNumber(long numberLength) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while ((long)i < numberLength) {
            sb.append(MAX_DIGIT_STR);
            ++i;
        }
        return Long.parseLong(sb.toString());
    }

    public synchronized String next() {
        int currentTime = SystemClock.millisClock().seconds();
        if (this.lastTimestamp > (long)currentTime && this.config.getTimeFallbackStrategy() == 0) {
            throw new IdGenerateException("\u53d1\u751f\u65f6\u95f4\u56de\u9000\u9519\u8bef\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01\u5f53\u524d\u65f6\u95f4=" + currentTime + ", \u4e0a\u6b21\u751f\u6210\u65f6\u95f4={}" + this.lastTimestamp);
        }
        if (this.lastTimestamp < (long)currentTime) {
            this.resetTime();
        }
        ++this.seq;
        if (this.seq >= this.maxSequence) {
            this.seq = 1L;
        }
        if (this.seq == this.tailSeq && this.config.getSeqOverflowStrategy() == 0) {
            throw new IdGenerateException("\u5e8f\u5217\u53f7\u6ea2\u51fa,\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        long unionId = this.seq << this.config.getWorkerIdBits() | this.workId;
        StringBuffer sb = new StringBuffer(this.timeStr);
        sb.append(this.zeroize(unionId, this.config.getNumberLength()));
        return sb.toString();
    }

    private void resetTime() {
        this.lastTimestamp = SystemClock.millisClock().seconds().intValue();
        this.timeStr = FsDateUtil.getReqDateyyyyMMddHHmmss((Date)new Date(this.lastTimestamp * 1000L));
        this.tailSeq = this.seq = RandomUtil.randomLong((long)1L, (long)this.maxSequence);
    }

    private String zeroize(long seriesNumber, int length) {
        int stringSize = this.stringSize(seriesNumber);
        return ZEROIZE_BUFFER[length - stringSize] + seriesNumber;
    }

    private int stringSize(long x) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (x < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    public static void main(String[] args) throws InterruptedException {
        RandomWorkerIdAssigner workerIdAssigner = new RandomWorkerIdAssigner();
        FsSnowflakeIdConfig config = new FsSnowflakeIdConfig();
        config.setNumberLength(6);
        config.setSequenceBits(16);
        config.setWorkerIdBits(4);
        config.setSeqOverflowStrategy(0);
        AtomicLong eqNum = new AtomicLong();
        int threadNum = 70;
        CountDownLatch countDownLatch2 = new CountDownLatch(threadNum);
        long currentTime = System.currentTimeMillis();
        Set hashSet = Collections.synchronizedSet(new HashSet(300000));
        FsSnowflakeIdGenerator worker = new FsSnowflakeIdGenerator(workerIdAssigner, config);
        System.out.println(worker.next());
        System.out.println(worker.next());
    }
}

