/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import com.alibaba.dubbo.common.Constants;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.extension.ExtensionLoader;
import com.alibaba.dubbo.common.store.DataStore;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.fshows.fsframework.core.utils.LogUtil;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=-9999)
public class GlobalDubboThreadMonitorFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalDubboThreadMonitorFilter.class);
    public static final String DUBBO_THREADPOOL = "DUBBO.ThreadPoolExecutor";
    private static int[] thresholdList = new int[]{50, 55, 60, 65, 70, 75, 80, 85, 90, 95};

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            DataStore dataStore = (DataStore)ExtensionLoader.getExtensionLoader(DataStore.class).getDefaultExtension();
            Map executors = dataStore.get(Constants.EXECUTOR_SERVICE_COMPONENT_KEY);
            for (Map.Entry entry : executors.entrySet()) {
                ExecutorService executor = (ExecutorService)entry.getValue();
                if (executor == null || !(executor instanceof ThreadPoolExecutor)) continue;
                ThreadPoolExecutor tp = (ThreadPoolExecutor)executor;
                StringBuffer sb = new StringBuffer();
                sb.append("activePoolSize:").append(tp.getActiveCount()).append("&");
                sb.append("maxPoolSize:").append(tp.getMaximumPoolSize()).append("&");
                sb.append("corePoolSize:").append(tp.getCorePoolSize()).append("&");
                sb.append("completedTask:").append(tp.getCompletedTaskCount()).append("&");
                sb.append("totalTaskCount:").append(tp.getTaskCount());
                LogUtil.info((Logger)log, (String)"GlobalDubboThreadMonitorFilter.invoke", (Object[])new Object[]{"EXCEED_" + RpcContext.getContext().getLocalHostName() + "%", sb.toString()});
                double threshold = new BigDecimal((float)tp.getActiveCount() / (float)tp.getMaximumPoolSize() * 100.0f).setScale(2, 4).doubleValue();
                for (int i = 0; i < thresholdList.length; ++i) {
                    if (!(threshold >= (double)thresholdList[i])) continue;
                    LogUtil.warn((Logger)log, (String)"GlobalDubboThreadMonitorFilter.invoke", (Object[])new Object[]{"EXCEED_" + thresholdList[i] + "%", sb.toString()});
                }
            }
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"GlobalDubboThreadMonitorFilter.invoke", (Throwable)e);
        }
        return invoker.invoke(invocation);
    }
}

