/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.idgen;

import com.fshows.fsframework.extend.idgen.exception.IdGenerateException;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class BitsAllocator {
    public static final short TOTAL_BITS = 64;
    private final short signBits = 1;
    private final short timestampBits;
    private final short workerIdBits;
    private final short sequenceBits;
    private final long maxWorkerId;
    private final long maxSequence;
    private final long maxDeltaSeconds;
    private final short timestampShift;
    private final short workerIdShift;

    public BitsAllocator(short timestampBits, short workerIdBits, short sequenceBits) {
        short allocateTotalBits = (short)(1 + timestampBits + workerIdBits + sequenceBits);
        if (allocateTotalBits != 64) {
            throw new IdGenerateException("allocated bits not enough for 64 bits");
        }
        this.timestampBits = timestampBits;
        this.workerIdBits = workerIdBits;
        this.sequenceBits = sequenceBits;
        this.maxDeltaSeconds = -1L << timestampBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxWorkerId = -1L << workerIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxSequence = -1L << sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.timestampShift = (short)(workerIdBits + sequenceBits);
        this.workerIdShift = sequenceBits;
    }

    public long allocate(long deltaSeconds, long workerId, long sequence) {
        return deltaSeconds << this.timestampShift | workerId << this.workerIdShift | sequence;
    }

    public int getSignBits() {
        return 1;
    }

    public short getTimestampBits() {
        return this.timestampBits;
    }

    public short getWorkerIdBits() {
        return this.workerIdBits;
    }

    public short getSequenceBits() {
        return this.sequenceBits;
    }

    public long getMaxWorkerId() {
        return this.maxWorkerId;
    }

    public long getMaxSequence() {
        return this.maxSequence;
    }

    public long getMaxDeltaSeconds() {
        return this.maxDeltaSeconds;
    }

    public short getTimestampShift() {
        return this.timestampShift;
    }

    public short getWorkerIdShift() {
        return this.workerIdShift;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

