/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.common.utils.CollectionUtils;
import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.dubbo.model.DubboServiceTimeConsumingLevelConfigModel;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=-9999)
public class GlobalSlowFacadeFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalSlowFacadeFilter.class);
    private static final String DUBBO_SERVICE_TIME_CONSUMING_LEVEL_CONFIG = "dubbo.service.time.consuming.level.config";
    private static volatile List<DubboServiceTimeConsumingLevelConfigModel> configModels = null;

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        List<DubboServiceTimeConsumingLevelConfigModel> timeConsumingLevelConfigModels = this.getTimeConsumingLevelConfigModels();
        if (CollectionUtils.isNotEmpty(timeConsumingLevelConfigModels)) {
            long rpcStartTime = SystemClock.millisClock().now();
            Result result = invoker.invoke(invocation);
            long rpcEndTime = SystemClock.millisClock().now();
            long timeConsuming = rpcEndTime - rpcStartTime;
            String methodName = invoker.getUrl().getPath() + "." + RpcContext.getContext().getMethodName();
            Object[] arguments = invocation.getArguments();
            for (DubboServiceTimeConsumingLevelConfigModel timeConsumingLevelConfigModel : timeConsumingLevelConfigModels) {
                if (timeConsuming <= (long)timeConsumingLevelConfigModel.getLowerThreshold().intValue()) continue;
                LogUtil.warn((Logger)log, (String)"RPC \u6162facade\u63a5\u53e3\u8c03\u7528\u7ed3\u675f\uff0c\u8017\u65f6\u7b49\u7ea7:\u3010{}\u3011\uff0cmethodName = {}, agruments = {}, time = {}ms", (Object[])new Object[]{timeConsumingLevelConfigModel.getLevel(), methodName, arguments, timeConsuming});
                break;
            }
            return result;
        }
        return invoker.invoke(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DubboServiceTimeConsumingLevelConfigModel> getTimeConsumingLevelConfigModels() {
        if (configModels == null) {
            GlobalSlowFacadeFilter globalSlowFacadeFilter = this;
            synchronized (globalSlowFacadeFilter) {
                List config;
                String configStr;
                if (configModels == null && StrUtil.isNotBlank((CharSequence)(configStr = ServiceBean.getSpringContext().getEnvironment().getProperty(DUBBO_SERVICE_TIME_CONSUMING_LEVEL_CONFIG))) && CollectionUtils.isNotEmpty((Collection)(config = JSONObject.parseArray((String)configStr, DubboServiceTimeConsumingLevelConfigModel.class)))) {
                    configModels = config.stream().sorted(Comparator.comparingInt(DubboServiceTimeConsumingLevelConfigModel::getLowerThreshold).reversed()).distinct().collect(Collectors.toList());
                }
            }
        }
        return configModels == null ? Lists.newArrayList() : configModels;
    }
}

