/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.fshows.fsframework.core.enums.RpcTimeConsumingLevelEnum;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider", "consumer"}, order=-9999)
public class GlobalSlowFacadeFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalSlowFacadeFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        long rpcStartTime = SystemClock.millisClock().now();
        Result result = invoker.invoke(invocation);
        long rpcEndTime = SystemClock.millisClock().now();
        long timeConsuming = rpcStartTime - rpcEndTime;
        String methodName = invocation.getMethodName();
        RpcTimeConsumingLevelEnum rpcTimeConsumingLevelEnum = RpcTimeConsumingLevelEnum.getRpcTimeConsumingLevelEnum((long)timeConsuming);
        switch (rpcTimeConsumingLevelEnum) {
            case MAJOR: 
            case WARN: 
            case ERROR: {
                LogUtil.warn((Logger)log, (String)"RPC \u6162facade\u63a5\u53e3\u8c03\u7528\u7ed3\u675f methodName = {}, time = {}ms, rpcTimeConsumingLevelEnum = {}", (Object[])new Object[]{methodName, timeConsuming, rpcTimeConsumingLevelEnum});
                break;
            }
        }
        return result;
    }
}

