/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.lock;

import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.lock.DistributedLock;
import com.fshows.fsframework.extend.lock.exception.ZookeeperLockException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperDistributedLock
implements DistributedLock {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperDistributedLock.class);
    private Map<String, InterProcessMutex> lockMap = new ConcurrentHashMap<String, InterProcessMutex>(16);
    private CuratorFramework curatorFramework;
    private String lockBasePath;

    public ZookeeperDistributedLock(CuratorFramework curatorFramework, String lockBasePath) {
        this.curatorFramework = curatorFramework;
        this.lockBasePath = this.createLockBasePath(lockBasePath);
    }

    @Override
    public void lock(String lockKey) {
        String lockPath = this.getLockPath(lockKey);
        long currentTime = System.currentTimeMillis();
        try {
            InterProcessMutex lock = this.getInterProcessMutex(lockPath);
            lock.acquire();
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011lock-\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff01lockPath = {}", (Throwable)e, (Object[])new Object[]{lockPath});
            throw new ZookeeperLockException(MessageFormat.format("\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011lock-\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff01lockPath = {0}", lockPath), e);
        }
        LogUtil.info((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011lock-\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff01 \u8017\u65f6 = {} \uff0clockPath = {}", (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockPath});
    }

    @Override
    public boolean tryLock(String lockKey) {
        return this.tryLock(lockKey, 0L);
    }

    @Override
    public boolean tryLock(String lockKey, long timeout) {
        String lockPath = this.getLockPath(lockKey);
        long currentTime = System.currentTimeMillis();
        try {
            InterProcessMutex lock = this.getInterProcessMutex(lockPath);
            lock.acquire(timeout, TimeUnit.MILLISECONDS);
            LogUtil.info((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u83b7\u53d6\u5230\u5206\u5e03\u5f0f\u9501\u6210\u529f\uff01 \u8017\u65f6 = {} \uff0clockPath = {}", (Object[])new Object[]{System.currentTimeMillis() - currentTime, lockPath});
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff01lockPath = {}", (Throwable)e, (Object[])new Object[]{lockPath});
            throw new ZookeeperLockException(MessageFormat.format("\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011tryLock-\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25\uff01lockPath = {0}", lockPath), e);
        }
        return true;
    }

    @Override
    public void unlock(String lockKey) {
        String lockPath = this.getLockPath(lockKey);
        try {
            InterProcessMutex lock = this.getInterProcessMutex(lockPath);
            lock.release();
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u3010\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011unlock-\u5206\u5e03\u5f0f\u9501\u89e3\u9501\u5931\u8d25\uff01lockPath = {}", (Throwable)e, (Object[])new Object[]{lockPath});
            throw new ZookeeperLockException(MessageFormat.format("unlock error, key={0}", lockKey), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InterProcessMutex getInterProcessMutex(String lockKey) {
        InterProcessMutex interProcessMutex = this.lockMap.get(lockKey);
        if (interProcessMutex == null) {
            Map<String, InterProcessMutex> map = this.lockMap;
            synchronized (map) {
                interProcessMutex = new InterProcessMutex(this.curatorFramework, lockKey);
            }
        }
        return interProcessMutex;
    }

    private String getLockPath(String lockKey) {
        if (StringUtils.isBlank((CharSequence)lockKey)) {
            throw new ZookeeperLockException("[zk\u5206\u5e03\u5f0f\u9501\u670d\u52a1]lockKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (lockKey.startsWith("/")) {
            lockKey = lockKey.substring(0, lockKey.length() - 1);
        }
        return this.lockBasePath + lockKey;
    }

    private String createLockBasePath(String lockBasePath) {
        if (lockBasePath == null) {
            return "";
        }
        if (!lockBasePath.endsWith("/")) {
            lockBasePath = lockBasePath + "/";
        }
        return lockBasePath;
    }
}

