/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.redis;

import com.fshows.fsframework.core.utils.LogUtil;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.redisson.Redisson;
import org.redisson.api.RBucket;
import org.redisson.api.RList;
import org.redisson.api.RLock;
import org.redisson.api.RMapCache;
import org.redisson.api.RSet;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RedisCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    private static final Long DEFAULT_EXPIRED = 300L;
    private static final String REDIS_KEY_PREFIX = "";
    private RedissonClient redisson;
    private String host;
    private String password;
    private Integer connectTimeout;

    @PostConstruct
    public void init() throws IOException {
        Config config = new Config();
        ((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(this.host).setPassword(this.password)).setDatabase(0).setPingTimeout(3000)).setTimeout(5000)).setSubscriptionConnectionMinimumIdleSize(1).setSubscriptionConnectionPoolSize(256).setConnectTimeout(this.connectTimeout.intValue())).setConnectionPoolSize(256).setConnectionMinimumIdleSize(1).setRetryAttempts(3)).setRetryInterval(3000)).setIdleConnectionTimeout(30000)).setClientName("com.fshows.fsframework.extend.redis.RedisCache");
        if (this.redisson == null) {
            this.redisson = Redisson.create((Config)config);
            LogUtil.info((Logger)log, (String)"redis\u8fde\u63a5\u6210\u529f,server={}", (Object[])new Object[]{this.host});
        } else {
            log.warn("redis \u91cd\u590d\u8fde\u63a5,config={}", (Object)config);
        }
    }

    public <T> T get(String key) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        return (T)bucket.get();
    }

    public String getString(String key) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        return (String)bucket.get();
    }

    public <T> void put(String key, T value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        bucket.set(value, DEFAULT_EXPIRED.longValue(), TimeUnit.SECONDS);
    }

    public void putString(String key, String value) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        bucket.set((Object)value, DEFAULT_EXPIRED.longValue(), TimeUnit.SECONDS);
    }

    public void putString(String key, String value, long expired) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key, (Codec)StringCodec.INSTANCE);
        bucket.set((Object)value, expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
    }

    public <T> void put(String key, T value, long expired) {
        RBucket bucket = this.redisson.getBucket(REDIS_KEY_PREFIX + key);
        bucket.set(value, expired <= 0L ? DEFAULT_EXPIRED : expired, TimeUnit.SECONDS);
    }

    public void remove(String key) {
        this.redisson.getBucket(REDIS_KEY_PREFIX + key).delete();
    }

    public boolean exists(String key) {
        return this.redisson.getBucket(REDIS_KEY_PREFIX + key).isExists();
    }

    public <T> RList<T> getRedisList(String key) {
        return this.redisson.getList(REDIS_KEY_PREFIX + key);
    }

    public <K, V> RMapCache<K, V> getRedisMap(String key) {
        return this.redisson.getMapCache(REDIS_KEY_PREFIX + key);
    }

    public <T> RSet<T> getRedisSet(String key) {
        return this.redisson.getSet(REDIS_KEY_PREFIX + key);
    }

    public RLock getRedisLock(String key) {
        return this.redisson.getLock(REDIS_KEY_PREFIX + key);
    }

    @PreDestroy
    public void close() {
        try {
            if (this.redisson != null) {
                this.redisson.shutdown();
            }
        }
        catch (Exception ex) {
            LogUtil.error((Logger)log, (String)ex.getMessage(), (Throwable)ex);
        }
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }
}

