/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.ons.client;

import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.ons.client.IProducer;
import com.fshows.fsframework.extend.ons.client.ProduceBean;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerService
implements IProducer {
    private static final Logger log = LoggerFactory.getLogger(ProducerService.class);
    private ProduceBean produce;

    public ProducerService(ProduceBean bean) {
        this.produce = bean;
    }

    private boolean sendDelayMessage(Message message, String key, String body) {
        Producer producer = this.produce.getProducer();
        try {
            SendResult sendResult = producer.send(message);
            LogUtil.info((Logger)log, (String)"key={},body={},\u589e\u52a0\u5230\u6d88\u606f\u961f\u5217;sendResult={}", (Object[])new Object[]{key, body, JSON.toJSONString((Object)sendResult)});
            return true;
        }
        catch (ONSClientException e) {
            LogUtil.error((Logger)log, (String)"\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff1akey = {},body={}, Ex = {}", (Object[])new Object[]{key, body, ExceptionUtils.getRootCauseStackTrace((Throwable)e)});
            return false;
        }
    }

    @Override
    public boolean sendMessage(String msg) {
        if (msg == null) {
            LogUtil.warn((Logger)log, (String)"\u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg =null");
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), msg.getBytes());
        message.setKey(this.produce.getKeyPrefix() + msg);
        return this.sendDelayMessage(message, msg, msg);
    }

    @Override
    public boolean sendDelayMessage(String msg, long dliverTime) {
        if (msg == null) {
            LogUtil.warn((Logger)log, (String)"\u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg =null");
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), msg.getBytes());
        message.setKey(this.produce.getKeyPrefix() + msg);
        message.setStartDeliverTime(dliverTime);
        return this.sendDelayMessage(message, msg, msg);
    }

    @Override
    public boolean sendDelayMessage(String key, String body, long dliverTime) {
        if (body == null || key == null) {
            LogUtil.warn((Logger)log, (String)"\u7f3a\u5c11\u751f\u4ea7\u8005\u914d\u7f6e\u4fe1\u606f Msg ={},key={}", (Object[])new Object[]{body, key});
            return false;
        }
        Message message = new Message(this.produce.getTopicId(), this.produce.getTag(), body.getBytes());
        message.setKey(this.produce.getKeyPrefix() + key);
        message.setStartDeliverTime(dliverTime);
        return this.sendDelayMessage(message, key, body);
    }

    @Override
    public void start() {
        this.produce.getProducer().start();
    }

    @Override
    public void shutdown() {
        this.produce.getProducer().shutdown();
    }
}

