/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.event;

import com.aliyun.openservices.cms.CMSClient;
import com.aliyun.openservices.cms.exception.CMSException;
import com.aliyun.openservices.cms.model.impl.CustomEvent;
import com.aliyun.openservices.cms.request.CustomEventUploadRequest;
import com.aliyun.openservices.cms.response.CustomEventUploadResponse;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.aliyun.event.EventEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliyunEventUtil
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(AliyunEventUtil.class);
    private static final String OSS_ENDPOINT_OUT = "http://metrichub-cms-cn-hangzhou.aliyuncs.com";
    private LinkedBlockingQueue<EventEntry> eventQueue;
    private ScheduledExecutorService schedule;
    private CMSClient cmsClient;
    private static final String SUCCESS_CODE = "200";
    private static final int MAX_POLL_SIZE = 99;
    private static volatile AliyunEventUtil instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AliyunEventUtil getInstance(String accessKey, String secretKey) {
        if (instance != null) return instance;
        Class<AliyunEventUtil> clazz = AliyunEventUtil.class;
        synchronized (AliyunEventUtil.class) {
            if (instance != null) return instance;
            instance = new AliyunEventUtil(accessKey, secretKey);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private AliyunEventUtil() {
    }

    private AliyunEventUtil(String accessKey, String secretKey) {
        this.cmsClient = new CMSClient(OSS_ENDPOINT_OUT, accessKey, secretKey);
        this.eventQueue = new LinkedBlockingQueue(10000);
        this.schedule = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("aliyun-event-pool-%d").daemon(true).build());
        this.schedule.scheduleAtFixedRate(this, 5L, 1L, TimeUnit.SECONDS);
    }

    public boolean put(EventEntry event) {
        if (this.cmsClient == null) {
            return false;
        }
        boolean b = this.eventQueue.offer(event);
        if (!b) {
            log.warn("\u4e8b\u4ef6\u961f\u5217\u5df2\u6ee1\uff0c\u4e22\u5f03\u4e8b\u4ef6\uff1a{}", (Object)event);
            return false;
        }
        return true;
    }

    public boolean uploadEvent(EventEntry event) {
        try {
            if (this.cmsClient == null) {
                return false;
            }
            if (event == null) {
                return false;
            }
            CustomEventUploadRequest request = (CustomEventUploadRequest)CustomEventUploadRequest.builder().append((CustomEvent)CustomEvent.builder().setContent(event.getContent()).setGroupId(Long.valueOf(event.getGroupId())).setName(event.getName()).build()).build();
            CustomEventUploadResponse response = this.cmsClient.putCustomEvent(request);
            if (response == null) {
                LogUtil.error((Logger)log, (String)"AliyunEventUtil ---- >> uploadEvent \u4e0a\u4f20\u5f02\u5e38, \u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object[])new Object[]{event.toString()});
                return false;
            }
            if (!SUCCESS_CODE.equals(response.getCode())) {
                LogUtil.error((Logger)log, (String)"AliyunEventUtil ---- >> uploadEvent \u4e0a\u4f20\u5f02\u5e38,\u8bf7\u6c42\u53c2\u6570\uff1a{}, \u8fd4\u56de\u7ed3\u679c\uff1arequestId={}, code = {},message={}", (Object[])new Object[]{event.toString(), response.getRequestId(), response.getCode(), response.getMessage()});
                return false;
            }
            return true;
        }
        catch (CMSException e) {
            LogUtil.error((Logger)log, (String)"AliyunEventUtil ---- >> uploadEvent \u4e0a\u4f20\u5f02\u5e38, \u53c2\u6570: param = {}, \u5f02\u5e38: Ex = {}", (Object[])new Object[]{event.getContent(), e});
            return false;
        }
    }

    public boolean uploadEventBatch(List<EventEntry> events) {
        if (this.cmsClient == null) {
            return false;
        }
        ArrayList<CustomEvent> eventList = new ArrayList<CustomEvent>();
        for (EventEntry event : events) {
            eventList.add((CustomEvent)CustomEvent.builder().setContent(event.getContent()).setGroupId(Long.valueOf(event.getGroupId())).setName(event.getName()).build());
        }
        return this.uploadEventBatch0(eventList);
    }

    private boolean uploadEventBatch0(List<CustomEvent> eventList) {
        try {
            if (eventList == null || eventList.isEmpty()) {
                return false;
            }
            CustomEventUploadRequest request = (CustomEventUploadRequest)CustomEventUploadRequest.builder().setEventList(eventList).build();
            CustomEventUploadResponse response = this.cmsClient.putCustomEvent(request);
            if (response == null) {
                return false;
            }
            if (!SUCCESS_CODE.equals(response.getCode())) {
                LogUtil.error((Logger)log, (String)"AliyunEventUtil ---- >> uploadEventBatch \u4e0a\u4f20\u5f02\u5e38,\u8fd4\u56de\u7ed3\u679c\uff1arequestId={}, code = {},message={}", (Object[])new Object[]{response.getRequestId(), response.getCode(), response.getMessage()});
                return false;
            }
            return true;
        }
        catch (CMSException e) {
            LogUtil.error((Logger)log, (String)"AliyunEventUtil ---- >> uploadEvent \u4e0a\u4f20\u5f02\u5e38: Ex = {}", (Throwable)e);
            this.cmsClient = null;
            return false;
        }
    }

    @Override
    public void run() {
        do {
            this.batchPut();
        } while (this.eventQueue.size() > 10);
    }

    private void batchPut() {
        EventEntry e;
        ArrayList<CustomEvent> events = new ArrayList<CustomEvent>();
        for (int i = 0; i < 99 && (e = this.eventQueue.poll()) != null; ++i) {
            events.add((CustomEvent)CustomEvent.builder().setContent(e.getContent()).setName(e.getName()).setGroupId(Long.valueOf(e.getGroupId())).build());
        }
        if (events.isEmpty()) {
            return;
        }
        this.uploadEventBatch0(events);
    }
}

