/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.common.exception;

import com.fshows.fsframework.common.exception.BaseException;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ExternalException
extends BaseException
implements Serializable {
    private static final long serialVersionUID = 4527790761300625166L;
    protected String projectId;
    protected String businessType;

    public ExternalException(String code, String msg) {
        super(msg);
        this.code = code;
    }

    public ExternalException(String code, String subCode, String msg) {
        super(msg);
        this.code = code;
        this.subCode = subCode;
        this.msg = msg;
    }

    public ExternalException init(String projectId, String businessType) {
        this.projectId = projectId;
        this.businessType = businessType;
        return this;
    }

    @Override
    public ExternalException newInstance(String msgFormat, Object ... args) {
        this.msg = MessageFormat.format(msgFormat, args);
        return this;
    }

    public ExternalException() {
    }

    public ExternalException(String message, Throwable cause) {
        super(message, cause);
    }

    public ExternalException(Throwable cause) {
        super(cause);
    }

    public ExternalException(String message) {
        super(message);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

