/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.fbank.openapi.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertFileUtils.class);
    private static final String STORE_TYPE_PKCS12 = "PKCS12";
    private static final String CERT_TYPE_X509 = "X.509";
    public static final String ALGORITHM_RSA = "RSA";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getPublicKeyFormCerFile(String cerFileName) {
        Path path = Paths.get(cerFileName, new String[0]);
        try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
            CertificateFactory instance = CertificateFactory.getInstance(CERT_TYPE_X509);
            Certificate certificate = instance.generateCertificate(inStream);
            PublicKey publicKey = certificate.getPublicKey();
            String string = Base64.encodeBase64String((byte[])publicKey.getEncoded());
            return string;
        }
        catch (IOException | CertificateException e) {
            LOGGER.error("get public key from cer file error ", (Throwable)e);
            return null;
        }
    }

    public static String getPrivateKeyFromPfxFile(String pfxFileName, String pfxPassword) {
        try {
            KeyStore keyStore = CertFileUtils.getKeyStore(pfxFileName, pfxPassword);
            String keyAlias = CertFileUtils.getKeyAlias(keyStore);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, pfxPassword.toCharArray());
            return Base64.encodeBase64String((byte[])privateKey.getEncoded());
        }
        catch (Exception e) {
            LOGGER.error("get private key from pfx file error ", (Throwable)e);
            return null;
        }
    }

    public static String getPrivateKeyFromPfxFile(InputStream pfxFileName, String pfxPassword) {
        try {
            KeyStore keyStore = CertFileUtils.getKeyStore(pfxFileName, pfxPassword);
            String keyAlias = CertFileUtils.getKeyAlias(keyStore);
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, pfxPassword.toCharArray());
            return Base64.encodeBase64String((byte[])privateKey.getEncoded());
        }
        catch (Exception e) {
            LOGGER.error("get private key from pfx file error ", (Throwable)e);
            return null;
        }
    }

    static KeyStore getKeyStore(InputStream pfxFileName, String pfxPassword) throws Exception {
        try (InputStream inStream = pfxFileName;){
            KeyStore keyStore = KeyStore.getInstance(STORE_TYPE_PKCS12);
            keyStore.load(inStream, pfxPassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    static KeyStore getKeyStore(String pfxFileName, String pfxPassword) throws Exception {
        Path path = Paths.get(pfxFileName, new String[0]);
        try (InputStream inStream = Files.newInputStream(path, new OpenOption[0]);){
            KeyStore keyStore = KeyStore.getInstance(STORE_TYPE_PKCS12);
            keyStore.load(inStream, pfxPassword.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    static String getKeyAlias(KeyStore keyStore) throws KeyStoreException {
        String keyAlias = null;
        Enumeration<String> aliases = keyStore.aliases();
        if (aliases.hasMoreElements()) {
            keyAlias = aliases.nextElement();
        }
        return keyAlias;
    }

    public static PublicKey toPublicKey(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        byte[] keyBytes = Base64.decodeBase64((String)publicKey);
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
        return keyFactory.generatePublic(x509KeySpec);
    }

    public static PrivateKey toPrivateKey(String privateKey) throws Exception {
        byte[] keyBytes = Base64.decodeBase64((String)privateKey);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM_RSA);
        return keyFactory.generatePrivate(keySpec);
    }
}

