/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.com.fbank.openapi.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.fshows.com.fbank.openapi.sdk.client.FBankOpenApiClient;
import com.fshows.com.fbank.openapi.sdk.client.OpenParameters;
import com.fshows.com.fbank.openapi.sdk.config.Configuration;
import com.fshows.com.fbank.openapi.sdk.constant.AlgorithmTypeEnum;
import com.fshows.com.fbank.openapi.sdk.constant.ModuleCodeEnum;
import com.fshows.com.fbank.openapi.sdk.crypto.CryptoEncryptionService;
import com.fshows.com.fbank.openapi.sdk.crypto.CryptoSignatureService;
import com.fshows.com.fbank.openapi.sdk.service.OpenApiService;
import com.fshows.com.fbank.openapi.sdk.util.AESUtils;
import com.fshows.com.fbank.openapi.sdk.util.CryptoServiceUtils;
import com.fshows.com.fbank.openapi.sdk.util.SerialNoUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOpenApiService
implements OpenApiService {
    final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String execute(FBankOpenApiClient client, OpenParameters context) throws Exception {
        Configuration configuration = client.getConfiguration();
        String body = this.buildBody(configuration, context);
        HttpURLConnection connection = this.getHttpURLConnection(configuration, context);
        byte[] response = this.getResponse(connection, body, configuration.charset());
        String result = this.verifyAndDecrypt(connection, configuration, context, response);
        connection.disconnect();
        return result;
    }

    private String buildBody(Configuration configuration, OpenParameters context) throws Exception {
        String userId;
        String randomKey = AESUtils.randomKey();
        String encryptType = configuration.encryptType();
        CryptoEncryptionService aesEncryptionService = CryptoServiceUtils.getCryptoAESEncryptionService(encryptType);
        String data = aesEncryptionService.encrypt(context.getParams(), randomKey);
        this.logger.info("randomKey is {}, encryptType is {}, encrypt result is {}", new Object[]{randomKey, encryptType, data});
        String signType = configuration.signType();
        CryptoEncryptionService rsaEncryptionService = CryptoServiceUtils.getCryptoRSAEncryptionService(signType);
        String randomKeyEncrypt = rsaEncryptionService.encrypt(randomKey, configuration.fbankEncPubKey());
        this.logger.info("signType is {}, randomKeyEncrypt is {}", (Object)signType, (Object)randomKeyEncrypt);
        TreeMap<String, Object> requestMap = new TreeMap<String, Object>();
        requestMap.put("data", data);
        requestMap.put("randomKeyEncrypt", randomKeyEncrypt);
        requestMap.put("merchantNo", configuration.merchantNo());
        requestMap.put("channelNo", configuration.channelNo());
        requestMap.put("sdkVersion", "2.4.4");
        requestMap.put("timestamp", System.currentTimeMillis());
        requestMap.put("signType", signType);
        requestMap.put("encryptType", encryptType);
        if (null != configuration.appId() && !configuration.appId().isEmpty()) {
            requestMap.put("appId", configuration.appId());
            requestMap.put("siteId", configuration.siteId());
        }
        if (null != (userId = context.getUserId()) && !userId.isEmpty()) {
            requestMap.put("userId", userId);
        }
        JSONObject requestJO = new JSONObject(requestMap);
        String requestJSONString = requestJO.toJSONString();
        CryptoSignatureService cryptoSignatureService = CryptoServiceUtils.getCryptoSignatureService(signType);
        String signData = cryptoSignatureService.signature(requestJSONString, configuration);
        this.logger.info("signature result is {}", (Object)signData);
        requestJO.put("signData", (Object)signData);
        return requestJO.toJSONString();
    }

    private HttpURLConnection getHttpURLConnection(Configuration configuration, OpenParameters context) throws IOException {
        URL url = new URL(this.pseudoModuleCode(context, this.getRemoteAddress(configuration)));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.setHttpHeaders(configuration, context, connection);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        connection.setRequestMethod(this.getHttpMethod());
        connection.setConnectTimeout(configuration.connectionTimeout());
        connection.setReadTimeout(configuration.readTimeout());
        return connection;
    }

    protected String getRemoteAddress(Configuration configuration) {
        return configuration.remoteAddress();
    }

    private String pseudoModuleCode(OpenParameters context, String address) {
        if (!address.endsWith("/")) {
            address = address + "/";
        }
        if (ModuleCodeEnum.OPEN_API_FUNCTION.rawValue().equalsIgnoreCase(context.getModuleCode())) {
            address = address + "?function=" + context.getApiCode();
        }
        return address;
    }

    private void setHttpHeaders(Configuration configuration, OpenParameters context, HttpURLConnection connection) {
        connection.setRequestProperty("api_name", context.getApiName());
        connection.setRequestProperty("api_code", context.getApiCode());
        String moduleCode = context.getModuleCode();
        if (null != moduleCode) {
            connection.setRequestProperty("module_code", moduleCode);
        }
        this.setAlgorithm(configuration, connection, moduleCode);
        connection.setRequestProperty("api_version", context.getApiVersion());
        String clientSerialNo = SerialNoUtils.calculateSerialNo(context.getParams());
        connection.setRequestProperty("client_serial_no", clientSerialNo);
        connection.setRequestProperty("Content-Type", "application/json");
    }

    protected void setAlgorithm(Configuration configuration, HttpURLConnection connection, String moduleCode) {
        if (AlgorithmTypeEnum.RSA_HARDWARE.getAlgorithmType().equals(configuration.signType())) {
            connection.setRequestProperty("algorithm", "rsaDetached");
        }
        if (null != moduleCode && ModuleCodeEnum.OPEN_API_BASE_SERVICE.rawValue().equalsIgnoreCase(moduleCode)) {
            connection.setRequestProperty("algorithm", "rsaService");
        }
    }

    protected String getHttpMethod() {
        return "POST";
    }

    private byte[] getResponse(HttpURLConnection connection, String encryptedBody, Charset charset) throws IOException {
        try (OutputStream outputStream = connection.getOutputStream();){
            if (null != encryptedBody) {
                outputStream.write(encryptedBody.getBytes(charset));
                outputStream.flush();
            }
        }
        var5_5 = null;
        try (InputStream in = connection.getInputStream();){
            byte[] byArray = this.read(in);
            return byArray;
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private byte[] read(InputStream inputStream) throws IOException {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            int num;
            int defaultBufferSize = 8192;
            byte[] buffer = new byte[8192];
            this.logger.info("read data begin");
            while ((num = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, num);
            }
            byte[] readResult = outputStream.toByteArray();
            this.logger.info("read data end");
            byte[] byArray = readResult;
            return byArray;
        }
    }

    public String verifyAndDecrypt(HttpURLConnection connection, Configuration configuration, OpenParameters context, byte[] response) throws Exception {
        String responseStr = new String(response, configuration.charset());
        JSONObject responseJO = JSONObject.parseObject((String)responseStr);
        if (null == responseJO || !responseJO.containsKey((Object)"signData")) {
            return responseStr;
        }
        String pubKey = configuration.fbankSignPubKey();
        JSONObject json = this.verifySignature(configuration, responseStr, pubKey);
        return this.decryptResult(configuration, json);
    }

    private JSONObject verifySignature(Configuration configuration, String encryptedResult, String publicKey) throws Exception {
        Map encryptedResultMap = (Map)JSONObject.parseObject((String)encryptedResult, (TypeReference)new TypeReference<TreeMap<String, Object>>(){}, (Feature[])new Feature[0]);
        Object signData = encryptedResultMap.remove("signData");
        JSONObject encryptedResultJson = new JSONObject(encryptedResultMap);
        CryptoSignatureService cryptoService = CryptoServiceUtils.getCryptoSignatureService(configuration.signType());
        boolean verifyResult = cryptoService.verifySignature(encryptedResultJson.toJSONString(), signData.toString(), publicKey);
        if (!verifyResult) {
            this.logger.error("The result signature verify failed, encryptedResult is : {} ", (Object)encryptedResult);
            throw new IllegalArgumentException("Verify signature failed.");
        }
        return encryptedResultJson;
    }

    private String decryptResult(Configuration configuration, JSONObject json) throws Exception {
        String encryptedRandomKey = json.getString("randomKeyEncrypt");
        CryptoEncryptionService rsaCryptoEncryptionService = CryptoServiceUtils.getCryptoRSAEncryptionService(configuration.signType());
        String randomKey = rsaCryptoEncryptionService.decrypt(encryptedRandomKey, configuration.privateKey());
        CryptoEncryptionService aesCryptoEncryptionService = CryptoServiceUtils.getCryptoAESEncryptionService(configuration.encryptType());
        return aesCryptoEncryptionService.decrypt(json.getString("data"), randomKey);
    }
}

