/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

/**
 * @author buhao
 * @version VerifyWithdrawalsResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class VerifyWithdrawalsResponseBody extends FbankResponseBody {
    /**
     * 交易订单号 (Y 32 交易完成后富民侧生成的唯一订单号)
     */
    private String tradeNo;
    /**
     * 订单状态 (Y 1 0：处理中 1：成功 2：失败 15：已退汇（账户提现接口为异步，判断交易的结果以异步通知状态或交易详情查询状态为准，切勿以接口返回“000000”判断）)
     */
    private String tradeStatus;
    /**
     * 订单创建时间 (Y datatime yyyy-MM-dd HH:mm:ss)
     */
    private String createDateTime;
    /**
     * 银行简称 (Y String 银行简称)
     */
    private String bankShortName;

}