/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

/**
 * @author buhao
 * @version VerifyTransferResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class VerifyTransferResponseBody extends FbankResponseBody {
    /**
     * 交易订单号 (Y 32 交易请求完成后由交易系统生成的唯一流水号)
     */
    private String tradeNo;
    /**
     * 订单状态 (Y 1 枚举值： 0：处理中 1：成功 2：失败)
     */
    private String tradeStatus;
    /**
     * 订单创建时间 (Y datatime yyyy-MM-dd HH:mm:ss)
     */
    private String createDateTime;
    /**
     * 订单创建日期 (Y datatime yyyy-MM-dd)
     */
    private String createTime;

}