/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

/**
 * @author buhao
 * @version TransactionResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class TransactionResponseBody extends FbankResponseBody {
    /**
     * 出账方姓名 (Y 32 该笔交易订单中的出账方户名)
     */
    private String nameOut;
    /**
     * 银行卡预留手机号 (Y 11 该笔请求中传入的银行卡预留手机号（没有则为空字符串）)
     */
    private String phoneNo;
    /**
     * 交易金额 (Y <=15 单位是元，保留两位小数 0.00)
     */
    private String amount;
    /**
     * 证件号码 (Y 18 身份证号)
     */
    private String custIdNo;
    /**
     * 交易创建时间 (Y datatime yyyy-MM-dd HH:mm:ss)
     */
    private String createTime;
    /**
     * 失败描述 (Y 32 若无则为空字符串)
     */
    private String tradeErrorCode;
    /**
     * 入账方账号 (Y 32 该笔请求中的收款方)
     */
    private String accountIn;
    /**
     * 交易备注 (Y <=50 交易备注)
     */
    private String tradeRemark;
    /**
     * 交易完成时间 (Y datatime yyyy-MM-dd HH:mm:ss)
     */
    private String finishTime;
    /**
     * 交易状态 (Y 1 0：处理中 1：成功 2：失败 15：已退汇（该状态可反应该笔交易的最终状态，大小额通道提现成功后有小概率发生退汇）)
     */
    private String tradeStatus;
    /**
     * 证件类型 (Y 2 01：身份证)
     */
    private String custIdt;
    /**
     * 交易订单号 (Y 32 该笔请求完成后由富民系统生成的唯一订单号)
     */
    private String tradeNo;
    /**
     * 出账方账号 (Y 32 用户在企富通开立的账户号)
     */
    private String accountOut;
    /**
     * 币种 (Y 3 CNY:人民币)
     */
    private String currency;
    /**
     * 交易子类型 (Y 3 枚举值： 1-转入 2-用户提现 4-代付 19-清算专用 26-转账 34-账户消费 36-账户消费分帐分润 39-聚合支付虚帐结算 40-结算至虚拟户 45-代付提现(到卡) 46-无跳转支付充值 47-担保撤销 50-无跳转支付消费 62-代付提现(到虚户) 101-银联(支付宝)扫码支付 102-银联(支付宝)条码支付 103-银联(支付宝)公众号支付 104-银联(微信)条码支付（线上） 105-银联(微信)扫码支付（线上） 106-银联(微信)公众号支付（线上） 107-银联(微信)H5 支付（线上） 108-银联(微信)APP 支付（线上） 109-银联(微信)小程序支付（线上） 110-银联(微信)条码支付（线下） 111-银联(微信)扫码支付（线下） 112-银联(微信)公众号支付（线下） 113-银联(微信)小程序支付（线下） 114-银联(QQ)扫码支付 115-银联(QQ)条码支付 116-银联(QQ)公众号支付 117-银联(QQ)固定二维码支付 118-银联(QQ)APP 支付 133-打款认证 142-担保发薪)
     */
    private String subTradeType;
    /**
     * 入账方账户名 (Y 32 入账方户名)
     */
    private String nameIn;
    /**
     * 返回信息 (Y 6)
     */
    private String paymentMsg;
    /**
     * 返回编码 (Y 6)
     */
    private String paymentCode;

}