/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

/**
 * @author buhao
 * @version QueryVirtualNotificationResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class QueryVirtualNotificationResponseBody extends FbankResponseBody {
    /**
     * 通知集合 (Y 通知集合)
     */
    private String notifications;
    /**
     * 商户侧用户唯一ID (Y <=40 调用端传递给企富通的企业用户唯一 ID)
     */
    private String custMerchantNo;
    /**
     * 商户账号 (Y <=32 企业或者个人用户在企富通开立的账户号)
     */
    private String accountNo;
    /**
     * 交易金额 (Y <=15 交易金额)
     */
    private String amount;
    /**
     * 交易订单号 (Y <=32 富民侧的交易订单号)
     */
    private String tradeNo;
    /**
     * 交易日期 (Y <=20 2019-04-24 10:27:59)
     */
    private String tradeDate;
    /**
     * 交易类型 (Y 2 1-转入(线下入金) 2-用户提现 4-代付 19-清算专用 26-转账 34-手续费消费 36-消费分帐分润 39-聚合支付虚帐结算 40-结算至虚拟户 45-代付提现(到卡) 46-虚户充值 47-担保撤销 62-代付提现(到虚户) 133-打款认证 76：担保发薪汇总划付 77：担保发薪汇总划付退汇)
     */
    private String tradeType;
    /**
     * 交易备注 (Y <=255 交易备注)
     */
    private String tradeRemark;
    /**
     * 对手账户 (Y 40 根据借贷标识 C 时为出账方账号 D 时为入账方账号)
     */
    private String othAccountNo;

}