/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.response.body;

import com.fshows.fbank.sdk.response.FbankResponseBody;
import lombok.Data;

/**
 * @author buhao
 * @version QueryAccountBalResponseBody.java, v 0.1 2020-10-16 11:42 buhao
 */
@Data
public class QueryAccountBalResponseBody extends FbankResponseBody {
    /**
     * 合计余额 (Y 20)
     */
    private String sumBalance;
    /**
     * 合计冻结金额 (Y 20)
     */
    private String sumFrozenAmount;
    /**
     * 账户状态 (Y 1 0:关闭 1:正常 2:部分冻结 3:全额冻结 4:不进不出 5:结清 6:预开户7:只进不出 8:只出不进)
     */
    private String accountState;
    /**
     * 账户余额 (Y 20 当传入 account 为业务账户时，显示对应账户余额；当 account为余额账户时或不传，显示为余额账户余额)
     */
    private String balance;
    /**
     * 账户的可用金额 (Y 20 余额账户余额-余额账户的冻结金额)
     */
    private String availableBalance;
    /**
     * 账户的冻结金额 (Y 20)
     */
    private String frozenAmount;
    /**
     * 待清分账户状态 (Y 1 0:关闭 1:正常 2:部分冻结 3:全额冻结 4:不进不出 5:结清 6:预开户7:只进不出 8:只出不进)
     */
    private String innerAccountState;
    /**
     * 待清分账户余额 (Y 20)
     */
    private String innerBalance;
    /**
     * 待清分账户的可用金额 (Y 20 待清分账户余额-待清分账户的冻结金额)
     */
    private String innnerAvailableBalance;
    /**
     * 待清分账户的冻结金额 (Y 待清分账户的冻结金额)
     */
    private String innerFrozenAmount;

}