/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.fbank.sdk.request;

import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * @author buhao
 * @version VirtualAccountCallbackRequest.java, v 0.1 2020-10-19 09:58 buhao
 */
@Data
public class VirtualAccountCallbackRequest extends FbankRequest {
    /**
     * 商户侧会员号 (Y <=40 调用方传递给企富通的用户 ID)
     */
    @NotNull
    private String custMerchantNo;
    /**
     * 账户号 (Y <=32 用户在企富通开立的虚拟账号)
     */
    @NotNull
    private String accountNo;
    /**
     * 金额 (Y <=15 单位是元，保留两位小数 0.00)
     */
    @NotNull
    private String amount;
    /**
     * 流水号 (Y <=32 对应该笔交易的富民侧交易订单号)
     */
    @NotNull
    private String tradeNo;
    /**
     * 动账时间 (Y <=20 2019-04-24 10:27:59)
     */
    @NotNull
    private String tradeDate;
    /**
     * 交易类型 (Y 2 1-转入(线下入金) 2-用户提现 4-代付 19-清算专用 26-转账 34-账户消费 36-账户消费分帐分润 39-聚合支付虚帐结算 40-结算至虚拟户 45-代付提现(到卡) 46-无跳转支付充值 47-担保撤销 50-无跳转支付消费 62-代付提现(到虚户) 133-打款认证)
     */
    @NotNull
    private String tradeType;
    /**
     * 账务类型 (Y 2 1-充值 2-提现 3-转账 25-余额户消费 27-退款 30-企业绑定账户入金 31-企业非绑定账户入金 39-商户结算上帐 40-提现手续费收益 51-虚账代付 57-提现退汇 58-提现手续费退汇)
     */
    @NotNull
    private String accountHandleType;
    /**
     * 商户订单号 (Y <=32 用户发起请求时由商户传递给企富通的唯一交易订单号)
     */
    @NotNull
    private String bizChannelOrderid;
    /**
     * 借贷标识 (Y 1 借贷标识: C：贷(增)，D：借(减))
     */
    @NotNull
    private String direction;
    /**
     * 交易备注 (Y <=50 交易备注)
     */
    @NotNull
    private String tradeRemark;
    /**
     * 对手账户 (Y 40 根据借贷标识 C 时为出账方账号 D 时为入账方账号)
     */
    @NotNull
    private String othAccountNo;
    /**
     * 对手账户名 (N 40 仅在入金时返回，其他为空)
     */
    private String othAccountName;
    /**
     * 对手行名 (N 40 仅在入金时返回，其他为空)
     */
    private String othBankName;
    /**
     * 对手行号 (N 40 仅在入金时返回，其他为空)
     */
    private String othBankCode;

}